#pragma once
#ifndef __MFTDiagPlaybackTAEF_H__
#define __MFTDiagPlaybackTAEF_H__

#include "MFTDTaefBase.h"

BEGIN_MODULE()
    MODULE_PROPERTY(L"Feature", L"MFTDiagPlayback")
    MODULE_PROPERTY(L"ThreadingModel", L"MTA")
END_MODULE()

class CMFTDiagPlaybackTAEF : public WEX::TestClass<CMFTDiagPlaybackTAEF>, public CMFTDTaefBaseWithActivate
{
public:
    CMFTDiagPlaybackTAEF(void);
    ~CMFTDiagPlaybackTAEF(void);

    BEGIN_TEST_CLASS(CMFTDiagPlaybackTAEF)
    END_TEST_CLASS()

    TEST_CLASS_SETUP(InitializeTestClass)
    TEST_CLASS_CLEANUP(FinalizeTestClass)

    BEGIN_TEST_METHOD(PlaybackTest110)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"836b3e7f-9fb6-4e81-9f91-f03c80984b59")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"abc55629-1a1d-45f7-99a9-df2cabbcd9f3")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder  HMFT Playback test 110")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MPEG4 - MPEG4 Basic Functionality Decodes MPEG4 Content using HMFT Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\33_H264_368x208_15_796kbps.3gp")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(PlaybackTest111)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"881807ed-259d-4876-ac34-acfe940b1aff")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"f4369d70-9a5f-4f47-bcf8-c89bf81f3522")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder  HMFT Playback test 111")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MPEG4 - MPEG4 Basic Functionality Decodes MPEG4 Content using HMFT Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\02_MPEG4_1920x1080_23976_7213kbps_Pro.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(PlaybackTest118) 
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"BAC2971A-4077-5D32-7783-1CA49BE973B4")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"7d95c3c9-e4f1-40b0-bca9-0028c61e49f1")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder  HMFT Playback test 118")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MPEG4 - MPEG4 Basic Functionality Decodes MPEG4 Content using HMFT Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\27_MSHDRef_Difficult_Edge_06_720x576i25f_h263_3080kbps.avi")
    END_TEST_METHOD() 
 

    BEGIN_TEST_METHOD(PlaybackTest125)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"B9A9B756-4B1D-B0B7-BC04-1A9F23B6154C")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d3383341-81e4-4f5f-abf8-d59c8af45a88")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT Playback test 125")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MPEG4 - MPEG4 Basic Functionality Decodes MPEG4 Content using HMFT Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\52_MSHDRef_Texture_High_01_320x240p30f_MPEG_850kbps.avi")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(PlaybackTest129)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"CE20B862-4317-C15F-5249-E686B1AEAA97")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"c028a13a-2b34-4580-b08c-9d534ffce34b")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT Playback test 129")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MPEG4 - MPEG4 Basic Functionality Decodes MPEG4 Content using HMFT Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MSHDRef_Texture_SkinTones_05_352x288p15f_900k.mp4")
    END_TEST_METHOD() 
 
 
    BEGIN_TEST_METHOD(PlaybackTest131)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"31B80225-73FE-4B73-9C39-AB7630FCDC85")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"2796d05d-140a-4a70-9708-95b74988a25e")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT Playback test 131")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MPEG4 - MPEG4 Basic Functionality Decodes MPEG4 Content using HMFT Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MSHDRef_Texture_SkinTones_05_352x288p15f_900kbps_XVid_MP4.avi")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(PlaybackTest150)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"7668FBC4-48EF-D3A1-F015-51A84F7BBCF2")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"96252a01-d6fb-41b5-9ac1-e8a4f57c7564")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 150")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\22_AVI_MJPEG_1920x1080_44Mbps_2997_ADPCM_11025kHz.avi")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(PlaybackTest151) 
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"25721676-47B8-588A-5502-AC97268DB199")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"9d25b1af-7c03-443c-ab9f-065bbfdc7d7c")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 151")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\23_AVI_MJPEG_720x480_10Mbps_2997_ADPCM_8kHz.avi")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(PlaybackTest152) 
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"47D5D48A-4573-7464-E5A1-E2A52DE712BA")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"b4d136b7-6a43-41ea-8a4c-41f2e0799b36")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 152")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\24_AVI_MJPEG_1280x720_21800Kbps_2997_ADPCM_11025kHz.avi")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(PlaybackTest153)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"D341BC9E-4DD5-A720-6510-868A40FA7B88")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"59e89197-28b6-48b7-8607-1b3176f0f837")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 153")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\39_MOV_PhotoJPEG_1280x720_BEST_30_PCM_48kHz.mov")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(PlaybackTest154) 
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"ED12A96D-479A-C0A6-38F1-11BCDEA79705")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"bad1b0bc-0409-4ce3-a16e-ffaa700fb138")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 154")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\39_MOV_PhotoJPEG_1280x720_LOSSLESS_30_PCM_48kHz.mov")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(PlaybackTest155)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"d80aa712-d7df-4956-9bb6-116bf89adf68")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"40b4e7fd-ec2f-4241-874b-505fa2ef9178")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 155")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MJPEG_144x176_15fps.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(PlaybackTest156)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"78605cc5-a359-43b0-8c26-5bada5f25a13")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"262f3cf2-e37e-412c-97e2-4545b6a31c58")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 156")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MJPEG_320x240_30fps.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(PlaybackTest157)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"a0f40b6f-34d1-4093-ad97-599aee1ef2e4")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"45150c75-2c2a-45d1-8ba5-b9fb244b2112")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 157")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MJPEG_640x360_30fps.avi")
    END_TEST_METHOD()


    BEGIN_TEST_METHOD(PlaybackTest421)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"d2f97766-bede-4e64-8e5f-905d6e20970b")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"032652fb-5169-4737-84ac-1ba0d55d5f3b")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder  HMFT Playback test 421")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MPEG4 - MPEG4 Basic Functionality Decodes MPEG4 Content using HMFT Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MSHDRef_Texture_SkinTones_05_352x288p15f_900kbps_XVid_MP4.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(PlaybackTest432)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"7dddcd93-b3bb-4529-bef0-f52bec8320c4")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8e2ea554-3d9c-4838-984e-30b0473994bb")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Playback test 432")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MJPEG_320x240_30fps.avi")
    END_TEST_METHOD()



    BEGIN_TEST_METHOD(PlaybackTest444)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"dd88d958-ed0a-412d-b1c1-49441bf3c3f8")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"b8baf64a-cafd-4e93-a903-20ba1a4124e2")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder  HMFT Stress test 444")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"120")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"120")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MPEG4 - MPEG4 Basic Functionality Decodes MPEG4 Content using HMFT Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080i30f_IYUV_30000kbps_XVid.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(PlaybackTest450)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"a789043f-ddd5-4c83-b4e3-b2fa059aeeaf")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"94f13b7a-f435-4579-b3b1-552e69780f5e")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT Stress test 450")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"120")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"120")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Playback Test: InputType MJPEG - MJPEG Basic Functionality Decodes MJPEG Content using HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\22_AVI_MJPEG_1920x1080_44Mbps_2997_ADPCM_11025kHz.avi")
    END_TEST_METHOD()


    BEGIN_TEST_METHOD(CustomXML)
        TEST_METHOD_PROPERTY(L"CustomXML", L"TRUE")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(ChildTest)
        TEST_METHOD_PROPERTY(L"ChildTest", L"TRUE")
    END_TEST_METHOD()

protected:
    HRESULT RunActualTest(const DWORD dwTestID, const GUID* pGUIDMFTUnderTest, const WCHAR* pszHWURL);
    HRESULT RunActualChildTest(
        const DWORD     dwInstance,
        const WCHAR*    pwszContextName,
        const DWORD     dwContextSize
        );
};

#endif //__MFTDiagTAEF_H__
