//*****************************************************************************
//***                        THIS FILE IS GENERATED                        ****
//***                       DO NOT MODIFY THIS FILE !!!                    ****
//*****************************************************************************
//*****************************************************************************
//* File: D3D11Wrapped.h
//* 
//* Description: 
//*     Interface specific D3D wrapper class declarations.
//*
//*****************************************************************************

#pragma once
#include "d3d11.h"
#include "D3DWrappedTypes.h"
#include "D3DWrapped.h"


////////////////////////////////////////////////////////////
//
// Wrapper classes
//
////////////////////////////////////////////////////////////

typedef D3D11_MAPPED_SUBRESOURCE D3D11_MAPPED_TEXTURE2D;
typedef D3D11_MAPPED_SUBRESOURCE D3D11_MAPPED_TEXTURE3D;

// {CE397BFB-1A1E-4feb-A3E3-24C57D1F60B3}
static const GUID C11DeviceGuid =
    { 0xce397bfb, 0x1a1e, 0x4feb, {0xa3, 0xe3, 0x24, 0xc5, 0x7d, 0x1f, 0x60, 0xb3} };



////////////////////////////////////////////////////////////
//
// C11DeviceChild
//
////////////////////////////////////////////////////////////

class C11DeviceChild : public CDeviceChild
{
public:
};


////////////////////////////////////////////////////////////
//
// C11DepthStencilState
//
////////////////////////////////////////////////////////////

class C11DepthStencilState : public CDepthStencilState, public C11DeviceChild
{
    ID3D11DepthStencilState *m_pDepthStencilState;

public:
    C11DepthStencilState( ID3D11DepthStencilState *pDepthStencilState );
    virtual ~C11DepthStencilState();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubDepthStencilState( int index, CDepthStencilState *pDepthStencilState ) {}
    virtual CDepthStencilState *Src() { return NULL; }
    virtual CDepthStencilState *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pDepthStencilState; }

    //
    // CDepthStencilState Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DepthStencilState **pInterface ) { *pInterface = (ID3D11DepthStencilState *) m_pDepthStencilState; }
    virtual CDepthStencilState *GetSubDepthStencilState( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_DEPTH_STENCIL_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pDepthStencilState; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11BlendState
//
////////////////////////////////////////////////////////////

class C11BlendState : public CBlendState, public C11DeviceChild
{
    ID3D11BlendState *m_pBlendState;

public:
    C11BlendState( ID3D11BlendState *pBlendState );
    virtual ~C11BlendState();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubBlendState( int index, CBlendState *pBlendState ) {}
    virtual CBlendState *Src() { return NULL; }
    virtual CBlendState *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pBlendState; }

    //
    // CBlendState Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11BlendState **pInterface ) { *pInterface = (ID3D11BlendState *) m_pBlendState; }
    virtual CBlendState *GetSubBlendState( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_BLEND_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pBlendState; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11RasterizerState
//
////////////////////////////////////////////////////////////

class C11RasterizerState : public CRasterizerState, public C11DeviceChild
{
    ID3D11RasterizerState *m_pRasterizerState;

public:
    C11RasterizerState( ID3D11RasterizerState *pRasterizerState );
    virtual ~C11RasterizerState();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubRasterizerState( int index, CRasterizerState *pRasterizerState ) {}
    virtual CRasterizerState *Src() { return NULL; }
    virtual CRasterizerState *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pRasterizerState; }

    //
    // CRasterizerState Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11RasterizerState **pInterface ) { *pInterface = (ID3D11RasterizerState *) m_pRasterizerState; }
    virtual CRasterizerState *GetSubRasterizerState( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_RASTERIZER_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pRasterizerState; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11Resource
//
////////////////////////////////////////////////////////////

class C11Resource : public CResource, public C11DeviceChild
{
public:
};


////////////////////////////////////////////////////////////
//
// C11Buffer
//
////////////////////////////////////////////////////////////

class C11Buffer : public CBuffer, public C11Resource
{
    ID3D11Buffer *m_pBuffer;

public:
    C11Buffer( ID3D11Buffer *pBuffer );
    virtual ~C11Buffer();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubBuffer( int index, CBuffer *pBuffer ) {}
    virtual CBuffer *Src() { return NULL; }
    virtual CBuffer *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pBuffer; }

    //
    // CBuffer Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Buffer **pInterface ) { *pInterface = (ID3D11Buffer *) m_pBuffer; }
    virtual CBuffer *GetSubBuffer( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_BUFFER_DESC * pDesc );

    ////////////////////////////////////////////////////////////
    // Map
    ////////////////////////////////////////////////////////////
    NRESULT Map(  D3D_MAP MapType, UINT MapFlags, void** ppData );

    ////////////////////////////////////////////////////////////
    // Unmap
    ////////////////////////////////////////////////////////////
    void Unmap(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CResource Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Resource **pInterface ) { *pInterface = (ID3D11Resource *) m_pBuffer; }
    virtual CResource *GetSubResource( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetType
    ////////////////////////////////////////////////////////////
    void GetType(  D3D_RESOURCE_DIMENSION * pResourceDimension );

    ////////////////////////////////////////////////////////////
    // SetEvictionPriority
    ////////////////////////////////////////////////////////////
    void SetEvictionPriority(  UINT EvictionPriority );

    ////////////////////////////////////////////////////////////
    // GetEvictionPriority
    ////////////////////////////////////////////////////////////
    UINT GetEvictionPriority(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pBuffer; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11Texture1D
//
////////////////////////////////////////////////////////////

class C11Texture1D : public CTexture1D, public C11Resource
{
    ID3D11Texture1D *m_pTexture1D;

public:
    C11Texture1D( ID3D11Texture1D *pTexture1D );
    virtual ~C11Texture1D();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubTexture1D( int index, CTexture1D *pTexture1D ) {}
    virtual CTexture1D *Src() { return NULL; }
    virtual CTexture1D *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pTexture1D; }

    //
    // CTexture1D Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Texture1D **pInterface ) { *pInterface = (ID3D11Texture1D *) m_pTexture1D; }
    virtual CTexture1D *GetSubTexture1D( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_TEXTURE1D_DESC * pDesc );

    ////////////////////////////////////////////////////////////
    // Map
    ////////////////////////////////////////////////////////////
    NRESULT Map(  UINT Subresource, D3D_MAP MapType, UINT MapFlags, void** ppData );

    ////////////////////////////////////////////////////////////
    // Unmap
    ////////////////////////////////////////////////////////////
    void Unmap(  UINT Subresource );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CResource Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Resource **pInterface ) { *pInterface = (ID3D11Resource *) m_pTexture1D; }
    virtual CResource *GetSubResource( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetType
    ////////////////////////////////////////////////////////////
    void GetType(  D3D_RESOURCE_DIMENSION * pResourceDimension );

    ////////////////////////////////////////////////////////////
    // SetEvictionPriority
    ////////////////////////////////////////////////////////////
    void SetEvictionPriority(  UINT EvictionPriority );

    ////////////////////////////////////////////////////////////
    // GetEvictionPriority
    ////////////////////////////////////////////////////////////
    UINT GetEvictionPriority(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pTexture1D; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11Texture2D
//
////////////////////////////////////////////////////////////

class C11Texture2D : public CTexture2D, public C11Resource
{
    ID3D11Texture2D *m_pTexture2D;

public:
    C11Texture2D( ID3D11Texture2D *pTexture2D );
    virtual ~C11Texture2D();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubTexture2D( int index, CTexture2D *pTexture2D ) {}
    virtual CTexture2D *Src() { return NULL; }
    virtual CTexture2D *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pTexture2D; }

    //
    // CTexture2D Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Texture2D **pInterface ) { *pInterface = (ID3D11Texture2D *) m_pTexture2D; }
    virtual CTexture2D *GetSubTexture2D( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_TEXTURE2D_DESC * pDesc );

    ////////////////////////////////////////////////////////////
    // Map
    ////////////////////////////////////////////////////////////
    NRESULT Map(  UINT Subresource, D3D_MAP MapType, UINT MapFlags, D3D_MAPPED_TEXTURE2D* pMappedTex2D );

    ////////////////////////////////////////////////////////////
    // Unmap
    ////////////////////////////////////////////////////////////
    void Unmap(  UINT Subresource );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CResource Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Resource **pInterface ) { *pInterface = (ID3D11Resource *) m_pTexture2D; }
    virtual CResource *GetSubResource( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetType
    ////////////////////////////////////////////////////////////
    void GetType(  D3D_RESOURCE_DIMENSION * pResourceDimension );

    ////////////////////////////////////////////////////////////
    // SetEvictionPriority
    ////////////////////////////////////////////////////////////
    void SetEvictionPriority(  UINT EvictionPriority );

    ////////////////////////////////////////////////////////////
    // GetEvictionPriority
    ////////////////////////////////////////////////////////////
    UINT GetEvictionPriority(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pTexture2D; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11Texture3D
//
////////////////////////////////////////////////////////////

class C11Texture3D : public CTexture3D, public C11Resource
{
    ID3D11Texture3D *m_pTexture3D;

public:
    C11Texture3D( ID3D11Texture3D *pTexture3D );
    virtual ~C11Texture3D();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubTexture3D( int index, CTexture3D *pTexture3D ) {}
    virtual CTexture3D *Src() { return NULL; }
    virtual CTexture3D *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pTexture3D; }

    //
    // CTexture3D Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Texture3D **pInterface ) { *pInterface = (ID3D11Texture3D *) m_pTexture3D; }
    virtual CTexture3D *GetSubTexture3D( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_TEXTURE3D_DESC * pDesc );

    ////////////////////////////////////////////////////////////
    // Map
    ////////////////////////////////////////////////////////////
    NRESULT Map(  UINT Subresource, D3D_MAP MapType, UINT MapFlags, D3D_MAPPED_TEXTURE3D* pMappedTex3D );

    ////////////////////////////////////////////////////////////
    // Unmap
    ////////////////////////////////////////////////////////////
    void Unmap(  UINT Subresource );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CResource Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Resource **pInterface ) { *pInterface = (ID3D11Resource *) m_pTexture3D; }
    virtual CResource *GetSubResource( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetType
    ////////////////////////////////////////////////////////////
    void GetType(  D3D_RESOURCE_DIMENSION * pResourceDimension );

    ////////////////////////////////////////////////////////////
    // SetEvictionPriority
    ////////////////////////////////////////////////////////////
    void SetEvictionPriority(  UINT EvictionPriority );

    ////////////////////////////////////////////////////////////
    // GetEvictionPriority
    ////////////////////////////////////////////////////////////
    UINT GetEvictionPriority(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pTexture3D; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11View
//
////////////////////////////////////////////////////////////

class C11View : public CView, public C11DeviceChild
{
public:
};


////////////////////////////////////////////////////////////
//
// C11ShaderResourceView
//
////////////////////////////////////////////////////////////

class C11ShaderResourceView : public CShaderResourceView, public C11View
{
    ID3D11ShaderResourceView *m_pShaderResourceView;

public:
    C11ShaderResourceView( ID3D11ShaderResourceView *pShaderResourceView );
    virtual ~C11ShaderResourceView();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubShaderResourceView( int index, CShaderResourceView *pShaderResourceView ) {}
    virtual CShaderResourceView *Src() { return NULL; }
    virtual CShaderResourceView *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pShaderResourceView; }

    //
    // CShaderResourceView Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11ShaderResourceView **pInterface ) { *pInterface = (ID3D11ShaderResourceView *) m_pShaderResourceView; }
    virtual CShaderResourceView *GetSubShaderResourceView( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_SHADER_RESOURCE_VIEW_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CView Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11View **pInterface ) { *pInterface = (ID3D11View *) m_pShaderResourceView; }
    virtual CView *GetSubView( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetResource
    ////////////////////////////////////////////////////////////
    void GetResource(  CResource ** ppResource );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pShaderResourceView; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11RenderTargetView
//
////////////////////////////////////////////////////////////

class C11RenderTargetView : public CRenderTargetView, public C11View
{
    ID3D11RenderTargetView *m_pRenderTargetView;

public:
    C11RenderTargetView( ID3D11RenderTargetView *pRenderTargetView );
    virtual ~C11RenderTargetView();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubRenderTargetView( int index, CRenderTargetView *pRenderTargetView ) {}
    virtual CRenderTargetView *Src() { return NULL; }
    virtual CRenderTargetView *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pRenderTargetView; }

    //
    // CRenderTargetView Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11RenderTargetView **pInterface ) { *pInterface = (ID3D11RenderTargetView *) m_pRenderTargetView; }
    virtual CRenderTargetView *GetSubRenderTargetView( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_RENDER_TARGET_VIEW_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CView Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11View **pInterface ) { *pInterface = (ID3D11View *) m_pRenderTargetView; }
    virtual CView *GetSubView( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetResource
    ////////////////////////////////////////////////////////////
    void GetResource(  CResource ** ppResource );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pRenderTargetView; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11DepthStencilView
//
////////////////////////////////////////////////////////////

class C11DepthStencilView : public CDepthStencilView, public C11View
{
    ID3D11DepthStencilView *m_pDepthStencilView;

public:
    C11DepthStencilView( ID3D11DepthStencilView *pDepthStencilView );
    virtual ~C11DepthStencilView();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubDepthStencilView( int index, CDepthStencilView *pDepthStencilView ) {}
    virtual CDepthStencilView *Src() { return NULL; }
    virtual CDepthStencilView *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pDepthStencilView; }

    //
    // CDepthStencilView Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DepthStencilView **pInterface ) { *pInterface = (ID3D11DepthStencilView *) m_pDepthStencilView; }
    virtual CDepthStencilView *GetSubDepthStencilView( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_DEPTH_STENCIL_VIEW_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CView Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11View **pInterface ) { *pInterface = (ID3D11View *) m_pDepthStencilView; }
    virtual CView *GetSubView( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetResource
    ////////////////////////////////////////////////////////////
    void GetResource(  CResource ** ppResource );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pDepthStencilView; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11VertexShader
//
////////////////////////////////////////////////////////////

class C11VertexShader : public CVertexShader, public C11DeviceChild
{
    ID3D11VertexShader *m_pVertexShader;

public:
    C11VertexShader( ID3D11VertexShader *pVertexShader );
    virtual ~C11VertexShader();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubVertexShader( int index, CVertexShader *pVertexShader ) {}
    virtual CVertexShader *Src() { return NULL; }
    virtual CVertexShader *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pVertexShader; }

    //
    // CVertexShader Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11VertexShader **pInterface ) { *pInterface = (ID3D11VertexShader *) m_pVertexShader; }
    virtual CVertexShader *GetSubVertexShader( int index ) { return NULL; }


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pVertexShader; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11GeometryShader
//
////////////////////////////////////////////////////////////

class C11GeometryShader : public CGeometryShader, public C11DeviceChild
{
    ID3D11GeometryShader *m_pGeometryShader;

public:
    C11GeometryShader( ID3D11GeometryShader *pGeometryShader );
    virtual ~C11GeometryShader();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubGeometryShader( int index, CGeometryShader *pGeometryShader ) {}
    virtual CGeometryShader *Src() { return NULL; }
    virtual CGeometryShader *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pGeometryShader; }

    //
    // CGeometryShader Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11GeometryShader **pInterface ) { *pInterface = (ID3D11GeometryShader *) m_pGeometryShader; }
    virtual CGeometryShader *GetSubGeometryShader( int index ) { return NULL; }


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pGeometryShader; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11PixelShader
//
////////////////////////////////////////////////////////////

class C11PixelShader : public CPixelShader, public C11DeviceChild
{
    ID3D11PixelShader *m_pPixelShader;

public:
    C11PixelShader( ID3D11PixelShader *pPixelShader );
    virtual ~C11PixelShader();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubPixelShader( int index, CPixelShader *pPixelShader ) {}
    virtual CPixelShader *Src() { return NULL; }
    virtual CPixelShader *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pPixelShader; }

    //
    // CPixelShader Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11PixelShader **pInterface ) { *pInterface = (ID3D11PixelShader *) m_pPixelShader; }
    virtual CPixelShader *GetSubPixelShader( int index ) { return NULL; }


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pPixelShader; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11InputLayout
//
////////////////////////////////////////////////////////////

class C11InputLayout : public CInputLayout, public C11DeviceChild
{
    ID3D11InputLayout *m_pInputLayout;

public:
    C11InputLayout( ID3D11InputLayout *pInputLayout );
    virtual ~C11InputLayout();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubInputLayout( int index, CInputLayout *pInputLayout ) {}
    virtual CInputLayout *Src() { return NULL; }
    virtual CInputLayout *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pInputLayout; }

    //
    // CInputLayout Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11InputLayout **pInterface ) { *pInterface = (ID3D11InputLayout *) m_pInputLayout; }
    virtual CInputLayout *GetSubInputLayout( int index ) { return NULL; }


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pInputLayout; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11SamplerState
//
////////////////////////////////////////////////////////////

class C11SamplerState : public CSamplerState, public C11DeviceChild
{
    ID3D11SamplerState *m_pSamplerState;

public:
    C11SamplerState( ID3D11SamplerState *pSamplerState );
    virtual ~C11SamplerState();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubSamplerState( int index, CSamplerState *pSamplerState ) {}
    virtual CSamplerState *Src() { return NULL; }
    virtual CSamplerState *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pSamplerState; }

    //
    // CSamplerState Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11SamplerState **pInterface ) { *pInterface = (ID3D11SamplerState *) m_pSamplerState; }
    virtual CSamplerState *GetSubSamplerState( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_SAMPLER_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pSamplerState; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11Asynchronous
//
////////////////////////////////////////////////////////////

class C11Asynchronous : public CAsynchronous, public C11DeviceChild
{
public:
};


////////////////////////////////////////////////////////////
//
// C11Query
//
////////////////////////////////////////////////////////////

class C11Query : public CQuery, public C11Asynchronous
{
public:
};


////////////////////////////////////////////////////////////
//
// C11Predicate
//
////////////////////////////////////////////////////////////

class C11Predicate : public CPredicate, public C11Query
{
    ID3D11Predicate *m_pPredicate;

public:
    C11Predicate( ID3D11Predicate *pPredicate );
    virtual ~C11Predicate();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubPredicate( int index, CPredicate *pPredicate ) {}
    virtual CPredicate *Src() { return NULL; }
    virtual CPredicate *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pPredicate; }

    //
    // CPredicate Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Predicate **pInterface ) { *pInterface = (ID3D11Predicate *) m_pPredicate; }
    virtual CPredicate *GetSubPredicate( int index ) { return NULL; }


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CQuery Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Query **pInterface ) { *pInterface = (ID3D11Query *) m_pPredicate; }
    virtual CQuery *GetSubQuery( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_QUERY_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CAsynchronous Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Asynchronous **pInterface ) { *pInterface = (ID3D11Asynchronous *) m_pPredicate; }
    virtual CAsynchronous *GetSubAsynchronous( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDataSize
    ////////////////////////////////////////////////////////////
    UINT GetDataSize(  );

    ////////////////////////////////////////////////////////////
    // Begin
    ////////////////////////////////////////////////////////////
    void Begin(  );

    ////////////////////////////////////////////////////////////
    // End
    ////////////////////////////////////////////////////////////
    void End(  );

    ////////////////////////////////////////////////////////////
    // GetData
    ////////////////////////////////////////////////////////////
    NRESULT GetData(  void* pData, UINT DataSize, UINT GetDataFlags );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pPredicate; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11Counter
//
////////////////////////////////////////////////////////////

class C11Counter : public CCounter, public C11Asynchronous
{
    ID3D11Counter *m_pCounter;

public:
    C11Counter( ID3D11Counter *pCounter );
    virtual ~C11Counter();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubCounter( int index, CCounter *pCounter ) {}
    virtual CCounter *Src() { return NULL; }
    virtual CCounter *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pCounter; }

    //
    // CCounter Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Counter **pInterface ) { *pInterface = (ID3D11Counter *) m_pCounter; }
    virtual CCounter *GetSubCounter( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    void GetDesc(  D3D_COUNTER_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CAsynchronous Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Asynchronous **pInterface ) { *pInterface = (ID3D11Asynchronous *) m_pCounter; }
    virtual CAsynchronous *GetSubAsynchronous( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDataSize
    ////////////////////////////////////////////////////////////
    UINT GetDataSize(  );

    ////////////////////////////////////////////////////////////
    // Begin
    ////////////////////////////////////////////////////////////
    void Begin(  );

    ////////////////////////////////////////////////////////////
    // End
    ////////////////////////////////////////////////////////////
    void End(  );

    ////////////////////////////////////////////////////////////
    // GetData
    ////////////////////////////////////////////////////////////
    NRESULT GetData(  void* pData, UINT DataSize, UINT GetDataFlags );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////

    //
    // CDeviceChild Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11DeviceChild **pInterface ) { *pInterface = (ID3D11DeviceChild *) m_pCounter; }
    virtual CDeviceChild *GetSubDeviceChild( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11Device
//
////////////////////////////////////////////////////////////

class C11Device : public CDevice
{
    ID3D11Device *m_pDevice;
    ID3D11DeviceContext *m_pDeviceDeferredContext;
    ID3D11DeviceContext *m_pDeviceImmediateContext;
    bool m_bUseDeferredContext;
public:
    HRESULT ExecDeferredContext();
    HRESULT SwitchDeferredContext(bool bForceDisable = false);
    ID3D11DeviceContext* GetCurrContext() { return m_bUseDeferredContext ? m_pDeviceDeferredContext : m_pDeviceImmediateContext; }
    ID3D11DeviceContext* GetImmContext() { return m_pDeviceImmediateContext; }
    ID3D11DeviceContext* GetDefContext() { return m_pDeviceDeferredContext; }
private:

public:
    C11Device( ID3D11Device *pDevice );
    virtual ~C11Device();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubDevice( int index, CDevice *pDevice ) {}
    virtual CDevice *Src() { return NULL; }
    virtual CDevice *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pDevice; }

    //
    // CDevice Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Device **pInterface ) { *pInterface = (ID3D11Device *) m_pDevice; }
    virtual CDevice *GetSubDevice( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // CreateBuffer
    ////////////////////////////////////////////////////////////
    NRESULT CreateBuffer(  const D3D_BUFFER_DESC * pDesc, const D3D_SUBRESOURCE_DATA * pInitialData, CBuffer ** ppBuffer );

    ////////////////////////////////////////////////////////////
    // CreateTexture1D
    ////////////////////////////////////////////////////////////
    NRESULT CreateTexture1D(  const D3D_TEXTURE1D_DESC * pDesc, const D3D_SUBRESOURCE_DATA * pInitialData, CTexture1D ** ppTexture1D );

    ////////////////////////////////////////////////////////////
    // CreateTexture2D
    ////////////////////////////////////////////////////////////
    NRESULT CreateTexture2D(  const D3D_TEXTURE2D_DESC * pDesc, const D3D_SUBRESOURCE_DATA * pInitialData, CTexture2D ** ppTexture2D );

    ////////////////////////////////////////////////////////////
    // CreateTexture3D
    ////////////////////////////////////////////////////////////
    NRESULT CreateTexture3D(  const D3D_TEXTURE3D_DESC * pDesc, const D3D_SUBRESOURCE_DATA * pInitialData, CTexture3D ** ppTexture3D );

    ////////////////////////////////////////////////////////////
    // CreateShaderResourceView
    ////////////////////////////////////////////////////////////
    NRESULT CreateShaderResourceView(  CResource * pResource, const D3D_SHADER_RESOURCE_VIEW_DESC * pDesc, CShaderResourceView ** ppSRView );

    ////////////////////////////////////////////////////////////
    // CreateRenderTargetView
    ////////////////////////////////////////////////////////////
    NRESULT CreateRenderTargetView(  CResource * pResource, const D3D_RENDER_TARGET_VIEW_DESC * pDesc, CRenderTargetView ** ppRTView );

    ////////////////////////////////////////////////////////////
    // CreateDepthStencilView
    ////////////////////////////////////////////////////////////
    NRESULT CreateDepthStencilView(  CResource * pResource, const D3D_DEPTH_STENCIL_VIEW_DESC * pDesc, CDepthStencilView ** ppDepthStencilView );

    ////////////////////////////////////////////////////////////
    // CreateInputLayout
    ////////////////////////////////////////////////////////////
    NRESULT CreateInputLayout(  const D3D_INPUT_ELEMENT_DESC * pInputElementDescs, UINT NumElements, const void * pShaderBytecodeWithInputSignature, SIZE_T BytecodeLength, CInputLayout ** ppInputLayout );

    ////////////////////////////////////////////////////////////
    // CreateVertexShader
    ////////////////////////////////////////////////////////////
    NRESULT CreateVertexShader(  const void * pShaderBytecode, SIZE_T BytecodeLength, CVertexShader ** ppVertexShader );

    ////////////////////////////////////////////////////////////
    // CreateGeometryShader
    ////////////////////////////////////////////////////////////
    NRESULT CreateGeometryShader(  const void * pShaderBytecode, SIZE_T BytecodeLength, CGeometryShader ** ppGeometryShader );

    ////////////////////////////////////////////////////////////
    // CreateGeometryShaderWithStreamOutput
    ////////////////////////////////////////////////////////////
    NRESULT CreateGeometryShaderWithStreamOutput(  const void * pShaderBytecode, SIZE_T BytecodeLength, const D3D_SO_DECLARATION_ENTRY * pSODeclaration, UINT NumEntries, UINT OutputStreamStride, CGeometryShader ** ppGeometryShader );

    ////////////////////////////////////////////////////////////
    // CreatePixelShader
    ////////////////////////////////////////////////////////////
    NRESULT CreatePixelShader(  const void * pShaderBytecode, SIZE_T BytecodeLength, CPixelShader ** ppPixelShader );

    ////////////////////////////////////////////////////////////
    // CreateBlendState
    ////////////////////////////////////////////////////////////
    NRESULT CreateBlendState(  const D3D_BLEND_DESC * pBlendStateDesc, CBlendState ** ppBlendState );

    ////////////////////////////////////////////////////////////
    // CreateDepthStencilState
    ////////////////////////////////////////////////////////////
    NRESULT CreateDepthStencilState(  const D3D_DEPTH_STENCIL_DESC * pDepthStencilDesc, CDepthStencilState ** ppDepthStencilState );

    ////////////////////////////////////////////////////////////
    // CreateRasterizerState
    ////////////////////////////////////////////////////////////
    NRESULT CreateRasterizerState(  const D3D_RASTERIZER_DESC * pRasterizerDesc, CRasterizerState ** ppRasterizerState );

    ////////////////////////////////////////////////////////////
    // CreateSamplerState
    ////////////////////////////////////////////////////////////
    NRESULT CreateSamplerState(  const D3D_SAMPLER_DESC * pSamplerDesc, CSamplerState ** ppSamplerState );

    ////////////////////////////////////////////////////////////
    // CreateQuery
    ////////////////////////////////////////////////////////////
    NRESULT CreateQuery(  const D3D_QUERY_DESC * pQueryDesc, CQuery ** ppQuery );

    ////////////////////////////////////////////////////////////
    // CreatePredicate
    ////////////////////////////////////////////////////////////
    NRESULT CreatePredicate(  const D3D_QUERY_DESC * pPredicateDesc, CPredicate ** ppPredicate );

    ////////////////////////////////////////////////////////////
    // CreateCounter
    ////////////////////////////////////////////////////////////
    NRESULT CreateCounter(  const D3D_COUNTER_DESC * pCounterDesc, CCounter ** ppCounter );

    ////////////////////////////////////////////////////////////
    // OpenSharedResource
    ////////////////////////////////////////////////////////////
    NRESULT OpenSharedResource(  HANDLE hResource, REFIID ReturnedInterface, void ** ppResource );

    ////////////////////////////////////////////////////////////
    // CheckFormatSupport
    ////////////////////////////////////////////////////////////
    NRESULT CheckFormatSupport(  DXGI_FORMAT Format, UINT * pFormatSupport );

    ////////////////////////////////////////////////////////////
    // CheckMultisampleQualityLevels
    ////////////////////////////////////////////////////////////
    NRESULT CheckMultisampleQualityLevels(  DXGI_FORMAT Format, UINT SampleCount, UINT * pNumQualityLevels );

    ////////////////////////////////////////////////////////////
    // CheckCounterInfo
    ////////////////////////////////////////////////////////////
    void CheckCounterInfo(  D3D_COUNTER_INFO * pCounterInfo );

    ////////////////////////////////////////////////////////////
    // CheckCounter
    ////////////////////////////////////////////////////////////
    NRESULT CheckCounter(  const D3D_COUNTER_DESC * pDesc, D3D_COUNTER_TYPE * pType, UINT * pActiveCounters, LPSTR szName, UINT * pNameLength, LPSTR szUnits, UINT * pUnitsLength, LPSTR szDescription, UINT * pDescriptionLength );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );

    ////////////////////////////////////////////////////////////
    // GetFeatureLevel
    ////////////////////////////////////////////////////////////
    D3D_FEATURE_LEVEL1 GetFeatureLevel(  );

    ////////////////////////////////////////////////////////////
    // GetCreationFlags
    ////////////////////////////////////////////////////////////
    UINT GetCreationFlags(  );

    ////////////////////////////////////////////////////////////
    // GetDeviceRemovedReason
    ////////////////////////////////////////////////////////////
    NRESULT GetDeviceRemovedReason(  );

    ////////////////////////////////////////////////////////////
    // SetExceptionMode
    ////////////////////////////////////////////////////////////
    NRESULT SetExceptionMode(  UINT RaiseFlags );

    ////////////////////////////////////////////////////////////
    // GetExceptionMode
    ////////////////////////////////////////////////////////////
    UINT GetExceptionMode(  );

    ////////////////////////////////////////////////////////////
    // VSSetConstantBuffers
    ////////////////////////////////////////////////////////////
    void VSSetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer *const * ppConstantBuffers );

    void VSSetConstantBuffers1( UINT StartSlot, UINT NumBuffers, CBuffer *const* ppConstantBuffers, UINT32 const* pOffsets, UINT32 const* ppNumConstants );

    ////////////////////////////////////////////////////////////
    // PSSetShaderResources
    ////////////////////////////////////////////////////////////
    void PSSetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView *const * ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // PSSetShader
    ////////////////////////////////////////////////////////////
    void PSSetShader(  CPixelShader * pPixelShader );

    ////////////////////////////////////////////////////////////
    // PSSetSamplers
    ////////////////////////////////////////////////////////////
    void PSSetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState *const * ppSamplers );

    ////////////////////////////////////////////////////////////
    // VSSetShader
    ////////////////////////////////////////////////////////////
    void VSSetShader(  CVertexShader * pVertexShader );

    ////////////////////////////////////////////////////////////
    // DrawIndexed
    ////////////////////////////////////////////////////////////
    void DrawIndexed(  UINT IndexCount, UINT StartIndexLocation, INT BaseVertexLocation );

    ////////////////////////////////////////////////////////////
    // Draw
    ////////////////////////////////////////////////////////////
    void Draw(  UINT VertexCount, UINT StartVertexLocation );

    ////////////////////////////////////////////////////////////
    // PSSetConstantBuffers
    ////////////////////////////////////////////////////////////
    void PSSetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer *const * ppConstantBuffers );

    void PSSetConstantBuffers1( UINT StartSlot, UINT NumBuffers, CBuffer *const* ppConstantBuffers, UINT32 const* pOffsets, UINT32 const* ppNumConstants );

    ////////////////////////////////////////////////////////////
    // IASetInputLayout
    ////////////////////////////////////////////////////////////
    void IASetInputLayout(  CInputLayout * pInputLayout );

    ////////////////////////////////////////////////////////////
    // IASetVertexBuffers
    ////////////////////////////////////////////////////////////
    void IASetVertexBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer *const * ppVertexBuffers, const UINT * pStrides, const UINT * pOffsets );

    ////////////////////////////////////////////////////////////
    // IASetIndexBuffer
    ////////////////////////////////////////////////////////////
    void IASetIndexBuffer(  CBuffer * pIndexBuffer, DXGI_FORMAT Format, UINT Offset );

    ////////////////////////////////////////////////////////////
    // DrawIndexedInstanced
    ////////////////////////////////////////////////////////////
    void DrawIndexedInstanced(  UINT IndexCountPerInstance, UINT InstanceCount, UINT StartIndexLocation, INT BaseVertexLocation, UINT StartInstanceLocation );

    ////////////////////////////////////////////////////////////
    // DrawInstanced
    ////////////////////////////////////////////////////////////
    void DrawInstanced(  UINT VertexCountPerInstance, UINT InstanceCount, UINT StartVertexLocation, UINT StartInstanceLocation );

    ////////////////////////////////////////////////////////////
    // GSSetConstantBuffers
    ////////////////////////////////////////////////////////////
    void GSSetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer *const * ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // GSSetShader
    ////////////////////////////////////////////////////////////
    void GSSetShader(  CGeometryShader * pShader );

    ////////////////////////////////////////////////////////////
    // IASetPrimitiveTopology
    ////////////////////////////////////////////////////////////
    void IASetPrimitiveTopology(  D3D_PRIMITIVE_TOPOLOGY Topology );

    ////////////////////////////////////////////////////////////
    // VSSetShaderResources
    ////////////////////////////////////////////////////////////
    void VSSetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView *const * ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // VSSetSamplers
    ////////////////////////////////////////////////////////////
    void VSSetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState *const * ppSamplers );

    ////////////////////////////////////////////////////////////
    // SetPredication
    ////////////////////////////////////////////////////////////
    void SetPredication(  CPredicate * pPredicate, BOOL PredicateValue );

    ////////////////////////////////////////////////////////////
    // GSSetShaderResources
    ////////////////////////////////////////////////////////////
    void GSSetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView *const * ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // GSSetSamplers
    ////////////////////////////////////////////////////////////
    void GSSetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState *const * ppSamplers );

    ////////////////////////////////////////////////////////////
    // OMSetRenderTargets
    ////////////////////////////////////////////////////////////
    void OMSetRenderTargets(  UINT NumViews, CRenderTargetView *const * ppRenderTargetViews, CDepthStencilView * pDepthStencilView );

    ////////////////////////////////////////////////////////////
    // OMSetBlendState
    ////////////////////////////////////////////////////////////
    void OMSetBlendState(  CBlendState * pBlendState, const FLOAT BlendFactor[4], UINT SampleMask );

    ////////////////////////////////////////////////////////////
    // OMSetDepthStencilState
    ////////////////////////////////////////////////////////////
    void OMSetDepthStencilState(  CDepthStencilState * pDepthStencilState, UINT StencilRef );

    ////////////////////////////////////////////////////////////
    // SOSetTargets
    ////////////////////////////////////////////////////////////
    void SOSetTargets(  UINT NumBuffers, CBuffer *const * ppSOTargets, const UINT * pOffsets );

    ////////////////////////////////////////////////////////////
    // DrawAuto
    ////////////////////////////////////////////////////////////
    void DrawAuto(  );

    ////////////////////////////////////////////////////////////
    // DrawIndexedInstancedIndirect
    ////////////////////////////////////////////////////////////
    void DrawIndexedInstancedIndirect(  CBuffer * pBufferForArgs, UINT AlignedByteOffsetForArgs );

    ////////////////////////////////////////////////////////////
    // DrawInstancedIndirect
    ////////////////////////////////////////////////////////////
    void DrawInstancedIndirect(  CBuffer * pBufferForArgs, UINT AlignedByteOffsetForArgs );

    ////////////////////////////////////////////////////////////
    // RSSetState
    ////////////////////////////////////////////////////////////
    void RSSetState(  CRasterizerState * pRasterizerState );

    ////////////////////////////////////////////////////////////
    // RSSetViewports
    ////////////////////////////////////////////////////////////
    void RSSetViewports(  UINT NumViewports, const D3D_VIEWPORT * pViewports );

    ////////////////////////////////////////////////////////////
    // RSSetScissorRects
    ////////////////////////////////////////////////////////////
    void RSSetScissorRects(  UINT NumRects, const D3D_RECT * pRects );

    ////////////////////////////////////////////////////////////
    // CopySubresourceRegion
    ////////////////////////////////////////////////////////////
    void CopySubresourceRegion(  CResource * pDstResource, UINT DstSubresource, UINT DstX, UINT DstY, UINT DstZ, CResource * pSrcResource, UINT SrcSubresource, const D3D_BOX * pSrcBox );

    ////////////////////////////////////////////////////////////
    // CopyResource
    ////////////////////////////////////////////////////////////
    void CopyResource(  CResource * pDstResource, CResource * pSrcResource );

    ////////////////////////////////////////////////////////////
    // UpdateSubresource
    ////////////////////////////////////////////////////////////
    void UpdateSubresource(  CResource * pDstResource, UINT DstSubresource, const D3D_BOX * pDstBox, const void * pSrcData, UINT SrcRowPitch, UINT SrcDepthPitch );

    ////////////////////////////////////////////////////////////
    // ClearRenderTargetView
    ////////////////////////////////////////////////////////////
    void ClearRenderTargetView(  CRenderTargetView * pRenderTargetView, const FLOAT ColorRGBA[4] );

    ////////////////////////////////////////////////////////////
    // ClearDepthStencilView
    ////////////////////////////////////////////////////////////
    void ClearDepthStencilView(  CDepthStencilView * pDepthStencilView, UINT ClearFlags, FLOAT Depth, UINT8 Stencil );

    ////////////////////////////////////////////////////////////
    // GenerateMips
    ////////////////////////////////////////////////////////////
    void GenerateMips(  CShaderResourceView * pShaderResourceView );

    ////////////////////////////////////////////////////////////
    // SetResourceMinLOD
    ////////////////////////////////////////////////////////////
    void SetResourceMinLOD(  CResource * pResource, FLOAT MinLOD );

    ////////////////////////////////////////////////////////////
    // GetResourceMinLOD
    ////////////////////////////////////////////////////////////
    FLOAT GetResourceMinLOD(  CResource * pResource );

    ////////////////////////////////////////////////////////////
    // ResolveSubresource
    ////////////////////////////////////////////////////////////
    void ResolveSubresource(  CResource * pDstResource, UINT DstSubresource, CResource * pSrcResource, UINT SrcSubresource, DXGI_FORMAT Format );

    ////////////////////////////////////////////////////////////
    // VSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    void VSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // PSGetShaderResources
    ////////////////////////////////////////////////////////////
    void PSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // PSGetShader
    ////////////////////////////////////////////////////////////
    void PSGetShader(  CPixelShader ** ppPixelShader );

    ////////////////////////////////////////////////////////////
    // PSGetSamplers
    ////////////////////////////////////////////////////////////
    void PSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // VSGetShader
    ////////////////////////////////////////////////////////////
    void VSGetShader(  CVertexShader ** ppVertexShader );

    ////////////////////////////////////////////////////////////
    // PSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    void PSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // IAGetInputLayout
    ////////////////////////////////////////////////////////////
    void IAGetInputLayout(  CInputLayout ** ppInputLayout );

    ////////////////////////////////////////////////////////////
    // IAGetVertexBuffers
    ////////////////////////////////////////////////////////////
    void IAGetVertexBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppVertexBuffers, UINT * pStrides, UINT * pOffsets );

    ////////////////////////////////////////////////////////////
    // IAGetIndexBuffer
    ////////////////////////////////////////////////////////////
    void IAGetIndexBuffer(  CBuffer ** pIndexBuffer, DXGI_FORMAT * Format, UINT * Offset );

    ////////////////////////////////////////////////////////////
    // GSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    void GSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // GSGetShader
    ////////////////////////////////////////////////////////////
    void GSGetShader(  CGeometryShader ** ppGeometryShader );

    ////////////////////////////////////////////////////////////
    // IAGetPrimitiveTopology
    ////////////////////////////////////////////////////////////
    void IAGetPrimitiveTopology(  D3D_PRIMITIVE_TOPOLOGY * pTopology );

    ////////////////////////////////////////////////////////////
    // VSGetShaderResources
    ////////////////////////////////////////////////////////////
    void VSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // VSGetSamplers
    ////////////////////////////////////////////////////////////
    void VSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // GetPredication
    ////////////////////////////////////////////////////////////
    void GetPredication(  CPredicate ** ppPredicate, BOOL * pPredicateValue );

    ////////////////////////////////////////////////////////////
    // GSGetShaderResources
    ////////////////////////////////////////////////////////////
    void GSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // GSGetSamplers
    ////////////////////////////////////////////////////////////
    void GSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // OMGetRenderTargets
    ////////////////////////////////////////////////////////////
    void OMGetRenderTargets(  UINT NumViews, CRenderTargetView ** ppRenderTargetViews, CDepthStencilView ** ppDepthStencilView );

    ////////////////////////////////////////////////////////////
    // OMGetBlendState
    ////////////////////////////////////////////////////////////
    void OMGetBlendState(  CBlendState ** ppBlendState, FLOAT BlendFactor[4], UINT * pSampleMask );

    ////////////////////////////////////////////////////////////
    // OMGetDepthStencilState
    ////////////////////////////////////////////////////////////
    void OMGetDepthStencilState(  CDepthStencilState ** ppDepthStencilState, UINT * pStencilRef );

    ////////////////////////////////////////////////////////////
    // SOGetTargets
    ////////////////////////////////////////////////////////////
    void SOGetTargets(  UINT NumBuffers, CBuffer ** ppSOTargets );

    ////////////////////////////////////////////////////////////
    // RSGetState
    ////////////////////////////////////////////////////////////
    void RSGetState(  CRasterizerState ** ppRasterizerState );

    ////////////////////////////////////////////////////////////
    // RSGetViewports
    ////////////////////////////////////////////////////////////
    void RSGetViewports(  UINT * pNumViewports, D3D_VIEWPORT * pViewports );

    ////////////////////////////////////////////////////////////
    // RSGetScissorRects
    ////////////////////////////////////////////////////////////
    void RSGetScissorRects(  UINT * pNumRects, D3D_RECT * pRects );

    ////////////////////////////////////////////////////////////
    // HSGetShaderResources
    ////////////////////////////////////////////////////////////
    void HSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // HSGetSamplers
    ////////////////////////////////////////////////////////////
    void HSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // HSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    void HSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // DSGetShaderResources
    ////////////////////////////////////////////////////////////
    void DSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // DSGetSamplers
    ////////////////////////////////////////////////////////////
    void DSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // DSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    void DSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // CSGetShaderResources
    ////////////////////////////////////////////////////////////
    void CSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // CSGetSamplers
    ////////////////////////////////////////////////////////////
    void CSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // CSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    void CSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // ClearState
    ////////////////////////////////////////////////////////////
    void ClearState(  );

    ////////////////////////////////////////////////////////////
    // Flush
    ////////////////////////////////////////////////////////////
    void Flush(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
    virtual HRESULT CreateTexture2DFromSwapChain( IDXGISwapChain **ppSwapChain, CTexture2D ** ppTexture2D );
    virtual HRESULT CreateDebug( CDebug ** ppDebug );
    virtual HRESULT CreateInfoQueue( CInfoQueue ** ppInfoQueue );
    virtual HRESULT CreateMultithread( CMultithread ** ppMultithread );
    virtual HRESULT CreateSwitchToRef( CSwitchToRef **ppSwitchToRef );
};


////////////////////////////////////////////////////////////
//
// C11Debug
//
////////////////////////////////////////////////////////////

class C11Debug : public CDebug
{
    ID3D11Debug *m_pDebug;

public:
    C11Debug( ID3D11Debug *pDebug );
    virtual ~C11Debug();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubDebug( int index, CDebug *pDebug ) {}
    virtual CDebug *Src() { return NULL; }
    virtual CDebug *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pDebug; }

    //
    // CDebug Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11Debug **pInterface ) { *pInterface = (ID3D11Debug *) m_pDebug; }
    virtual CDebug *GetSubDebug( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // SetFeatureMask
    ////////////////////////////////////////////////////////////
    NRESULT SetFeatureMask(  UINT Mask );

    ////////////////////////////////////////////////////////////
    // GetFeatureMask
    ////////////////////////////////////////////////////////////
    UINT GetFeatureMask(  );

    ////////////////////////////////////////////////////////////
    // SetPresentPerRenderOpDelay
    ////////////////////////////////////////////////////////////
    NRESULT SetPresentPerRenderOpDelay(  UINT Milliseconds );

    ////////////////////////////////////////////////////////////
    // GetPresentPerRenderOpDelay
    ////////////////////////////////////////////////////////////
    UINT GetPresentPerRenderOpDelay(  );

    ////////////////////////////////////////////////////////////
    // SetSwapChain
    ////////////////////////////////////////////////////////////
    NRESULT SetSwapChain(  IDXGISwapChain * pSwapChain );

    ////////////////////////////////////////////////////////////
    // GetSwapChain
    ////////////////////////////////////////////////////////////
    NRESULT GetSwapChain(  IDXGISwapChain ** ppSwapChain );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11SwitchToRef
//
////////////////////////////////////////////////////////////

class C11SwitchToRef : public CSwitchToRef
{
    ID3D11SwitchToRef *m_pSwitchToRef;

public:
    C11SwitchToRef( ID3D11SwitchToRef *pSwitchToRef );
    virtual ~C11SwitchToRef();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubSwitchToRef( int index, CSwitchToRef *pSwitchToRef ) {}
    virtual CSwitchToRef *Src() { return NULL; }
    virtual CSwitchToRef *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pSwitchToRef; }

    //
    // CSwitchToRef Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11SwitchToRef **pInterface ) { *pInterface = (ID3D11SwitchToRef *) m_pSwitchToRef; }
    virtual CSwitchToRef *GetSubSwitchToRef( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // SetUseRef
    ////////////////////////////////////////////////////////////
    BOOL SetUseRef(  BOOL UseRef );

    ////////////////////////////////////////////////////////////
    // GetUseRef
    ////////////////////////////////////////////////////////////
    BOOL GetUseRef(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// C11InfoQueue
//
////////////////////////////////////////////////////////////

class C11InfoQueue : public CInfoQueue
{
    ID3D11InfoQueue *m_pInfoQueue;

public:
    C11InfoQueue( ID3D11InfoQueue *pInfoQueue );
    virtual ~C11InfoQueue();

    ////////////////////////////////////////////////////////////
    // Sub object accessor overrides.
    // These functions return NULL since this is a non-multi class.
    ////////////////////////////////////////////////////////////
    virtual int GetSubObjectCount() const { return 0; }
    void SetSubInfoQueue( int index, CInfoQueue *pInfoQueue ) {}
    virtual CInfoQueue *Src() { return NULL; }
    virtual CInfoQueue *Ref() { return NULL; }
    virtual IUnknown *GetIUnknown() { return m_pInfoQueue; }

    //
    // CInfoQueue Overrides
    //

    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D11InfoQueue **pInterface ) { *pInterface = (ID3D11InfoQueue *) m_pInfoQueue; }
    virtual CInfoQueue *GetSubInfoQueue( int index ) { return NULL; }

    ////////////////////////////////////////////////////////////
    // SetMessageCountLimit
    ////////////////////////////////////////////////////////////
    NRESULT SetMessageCountLimit(  UINT64 MessageCountLimit );

    ////////////////////////////////////////////////////////////
    // ClearStoredMessages
    ////////////////////////////////////////////////////////////
    void ClearStoredMessages(  );

    ////////////////////////////////////////////////////////////
    // GetMessage
    ////////////////////////////////////////////////////////////
    NRESULT GetMessage(  UINT64 MessageIndex, D3D_MESSAGE * pMessage, SIZE_T * pMessageByteLength );

    ////////////////////////////////////////////////////////////
    // GetNumMessagesAllowedByStorageFilter
    ////////////////////////////////////////////////////////////
    UINT64 GetNumMessagesAllowedByStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // GetNumMessagesDeniedByStorageFilter
    ////////////////////////////////////////////////////////////
    UINT64 GetNumMessagesDeniedByStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // GetNumStoredMessages
    ////////////////////////////////////////////////////////////
    UINT64 GetNumStoredMessages(  );

    ////////////////////////////////////////////////////////////
    // GetNumStoredMessagesAllowedByRetrievalFilter
    ////////////////////////////////////////////////////////////
    UINT64 GetNumStoredMessagesAllowedByRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // GetNumMessagesDiscardedByMessageCountLimit
    ////////////////////////////////////////////////////////////
    UINT64 GetNumMessagesDiscardedByMessageCountLimit(  );

    ////////////////////////////////////////////////////////////
    // GetMessageCountLimit
    ////////////////////////////////////////////////////////////
    UINT64 GetMessageCountLimit(  );

    ////////////////////////////////////////////////////////////
    // AddStorageFilterEntries
    ////////////////////////////////////////////////////////////
    NRESULT AddStorageFilterEntries(  D3D_INFO_QUEUE_FILTER * pFilter );

    ////////////////////////////////////////////////////////////
    // GetStorageFilter
    ////////////////////////////////////////////////////////////
    NRESULT GetStorageFilter(  D3D_INFO_QUEUE_FILTER * pFilter, SIZE_T * pFilterByteLength );

    ////////////////////////////////////////////////////////////
    // ClearStorageFilter
    ////////////////////////////////////////////////////////////
    void ClearStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // PushEmptyStorageFilter
    ////////////////////////////////////////////////////////////
    NRESULT PushEmptyStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // PushCopyOfStorageFilter
    ////////////////////////////////////////////////////////////
    NRESULT PushCopyOfStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // PushStorageFilter
    ////////////////////////////////////////////////////////////
    NRESULT PushStorageFilter(  D3D_INFO_QUEUE_FILTER * pFilter );

    ////////////////////////////////////////////////////////////
    // PopStorageFilter
    ////////////////////////////////////////////////////////////
    void PopStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // GetStorageFilterStackSize
    ////////////////////////////////////////////////////////////
    UINT GetStorageFilterStackSize(  );

    ////////////////////////////////////////////////////////////
    // AddRetrievalFilterEntries
    ////////////////////////////////////////////////////////////
    NRESULT AddRetrievalFilterEntries(  D3D_INFO_QUEUE_FILTER * pFilter );

    ////////////////////////////////////////////////////////////
    // GetRetrievalFilter
    ////////////////////////////////////////////////////////////
    NRESULT GetRetrievalFilter(  D3D_INFO_QUEUE_FILTER * pFilter, SIZE_T * pFilterByteLength );

    ////////////////////////////////////////////////////////////
    // ClearRetrievalFilter
    ////////////////////////////////////////////////////////////
    void ClearRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // PushEmptyRetrievalFilter
    ////////////////////////////////////////////////////////////
    NRESULT PushEmptyRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // PushCopyOfRetrievalFilter
    ////////////////////////////////////////////////////////////
    NRESULT PushCopyOfRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // PushRetrievalFilter
    ////////////////////////////////////////////////////////////
    NRESULT PushRetrievalFilter(  D3D_INFO_QUEUE_FILTER * pFilter );

    ////////////////////////////////////////////////////////////
    // PopRetrievalFilter
    ////////////////////////////////////////////////////////////
    void PopRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // GetRetrievalFilterStackSize
    ////////////////////////////////////////////////////////////
    UINT GetRetrievalFilterStackSize(  );

    ////////////////////////////////////////////////////////////
    // AddMessage
    ////////////////////////////////////////////////////////////
    NRESULT AddMessage(  D3D_MESSAGE_CATEGORY Category, D3D_MESSAGE_SEVERITY Severity, D3D_MESSAGE_ID ID, LPCSTR pDescription );

    ////////////////////////////////////////////////////////////
    // AddApplicationMessage
    ////////////////////////////////////////////////////////////
    NRESULT AddApplicationMessage(  D3D_MESSAGE_SEVERITY Severity, LPCSTR pDescription );

    ////////////////////////////////////////////////////////////
    // SetBreakOnCategory
    ////////////////////////////////////////////////////////////
    NRESULT SetBreakOnCategory(  D3D_MESSAGE_CATEGORY Category, BOOL bEnable );

    ////////////////////////////////////////////////////////////
    // SetBreakOnSeverity
    ////////////////////////////////////////////////////////////
    NRESULT SetBreakOnSeverity(  D3D_MESSAGE_SEVERITY Severity, BOOL bEnable );

    ////////////////////////////////////////////////////////////
    // SetBreakOnID
    ////////////////////////////////////////////////////////////
    NRESULT SetBreakOnID(  D3D_MESSAGE_ID ID, BOOL bEnable );

    ////////////////////////////////////////////////////////////
    // GetBreakOnCategory
    ////////////////////////////////////////////////////////////
    BOOL GetBreakOnCategory(  D3D_MESSAGE_CATEGORY Category );

    ////////////////////////////////////////////////////////////
    // GetBreakOnSeverity
    ////////////////////////////////////////////////////////////
    BOOL GetBreakOnSeverity(  D3D_MESSAGE_SEVERITY Severity );

    ////////////////////////////////////////////////////////////
    // GetBreakOnID
    ////////////////////////////////////////////////////////////
    BOOL GetBreakOnID(  D3D_MESSAGE_ID ID );

    ////////////////////////////////////////////////////////////
    // SetMuteDebugOutput
    ////////////////////////////////////////////////////////////
    void SetMuteDebugOutput(  BOOL bMute );

    ////////////////////////////////////////////////////////////
    // GetMuteDebugOutput
    ////////////////////////////////////////////////////////////
    BOOL GetMuteDebugOutput(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};
