//*****************************************************************************
//***                        THIS FILE IS GENERATED                        ****
//***                       DO NOT MODIFY THIS FILE !!!                    ****
//*****************************************************************************
//*****************************************************************************
//* File: D3D10ValueSets.cpp
//* 
//* Description: 
//*     Defines classes that implement common ValueSets and filters related to enums
//*
//*****************************************************************************

// Ignore Prefast warnings 26060 (Range Precondition violation) and 28930 (Unused assignment of pointer variable)
#pragma warning( disable: 26060 )
#pragma warning( disable: 28930 )

#include "pch.h"
#include "D3D10ValueSets.h"

BEGIN_NAMED_VALUES( D3D10_INPUT_CLASSIFICATION )
    NAMED_VALUE( _T( "VERTEX_DATA" ), D3D10_INPUT_PER_VERTEX_DATA )
    NAMED_VALUE( _T( "INSTANCE_DATA" ), D3D10_INPUT_PER_INSTANCE_DATA )
END_NAMED_VALUES( D3D10_INPUT_CLASSIFICATION )

BEGIN_NAMED_VALUES( D3D10_FILL_MODE )
    NAMED_VALUE( _T( "WIREFRAME" ), D3D10_FILL_WIREFRAME )
    NAMED_VALUE( _T( "SOLID" ), D3D10_FILL_SOLID )
END_NAMED_VALUES( D3D10_FILL_MODE )

BEGIN_NAMED_VALUES( D3D10_CULL_MODE )
    NAMED_VALUE( _T( "NONE" ), D3D10_CULL_NONE )
    NAMED_VALUE( _T( "FRONT" ), D3D10_CULL_FRONT )
    NAMED_VALUE( _T( "BACK" ), D3D10_CULL_BACK )
END_NAMED_VALUES( D3D10_CULL_MODE )

BEGIN_NAMED_VALUES( D3D10_RESOURCE_DIMENSION )
    NAMED_VALUE( _T( "UNKNOWN" ), D3D10_RESOURCE_DIMENSION_UNKNOWN )
    NAMED_VALUE( _T( "BUFFER" ), D3D10_RESOURCE_DIMENSION_BUFFER )
    NAMED_VALUE( _T( "TEXTURE1D" ), D3D10_RESOURCE_DIMENSION_TEXTURE1D )
    NAMED_VALUE( _T( "TEXTURE2D" ), D3D10_RESOURCE_DIMENSION_TEXTURE2D )
    NAMED_VALUE( _T( "TEXTURE3D" ), D3D10_RESOURCE_DIMENSION_TEXTURE3D )
END_NAMED_VALUES( D3D10_RESOURCE_DIMENSION )

BEGIN_NAMED_VALUES( D3D10_DSV_DIMENSION )
    NAMED_VALUE( _T( "UNKNOWN" ), D3D10_DSV_DIMENSION_UNKNOWN )
    NAMED_VALUE( _T( "TEXTURE1D" ), D3D10_DSV_DIMENSION_TEXTURE1D )
    NAMED_VALUE( _T( "TEXTURE1DARRAY" ), D3D10_DSV_DIMENSION_TEXTURE1DARRAY )
    NAMED_VALUE( _T( "TEXTURE2D" ), D3D10_DSV_DIMENSION_TEXTURE2D )
    NAMED_VALUE( _T( "TEXTURE2DARRAY" ), D3D10_DSV_DIMENSION_TEXTURE2DARRAY )
    NAMED_VALUE( _T( "TEXTURE2DMS" ), D3D10_DSV_DIMENSION_TEXTURE2DMS )
    NAMED_VALUE( _T( "TEXTURE2DMSARRAY" ), D3D10_DSV_DIMENSION_TEXTURE2DMSARRAY )
END_NAMED_VALUES( D3D10_DSV_DIMENSION )

BEGIN_NAMED_VALUES( D3D10_RTV_DIMENSION )
    NAMED_VALUE( _T( "UNKNOWN" ), D3D10_RTV_DIMENSION_UNKNOWN )
    NAMED_VALUE( _T( "BUFFER" ), D3D10_RTV_DIMENSION_BUFFER )
    NAMED_VALUE( _T( "TEXTURE1D" ), D3D10_RTV_DIMENSION_TEXTURE1D )
    NAMED_VALUE( _T( "TEXTURE1DARRAY" ), D3D10_RTV_DIMENSION_TEXTURE1DARRAY )
    NAMED_VALUE( _T( "TEXTURE2D" ), D3D10_RTV_DIMENSION_TEXTURE2D )
    NAMED_VALUE( _T( "TEXTURE2DARRAY" ), D3D10_RTV_DIMENSION_TEXTURE2DARRAY )
    NAMED_VALUE( _T( "TEXTURE2DMS" ), D3D10_RTV_DIMENSION_TEXTURE2DMS )
    NAMED_VALUE( _T( "TEXTURE2DMSARRAY" ), D3D10_RTV_DIMENSION_TEXTURE2DMSARRAY )
    NAMED_VALUE( _T( "TEXTURE3D" ), D3D10_RTV_DIMENSION_TEXTURE3D )
END_NAMED_VALUES( D3D10_RTV_DIMENSION )

BEGIN_NAMED_VALUES( D3D10_USAGE )
    NAMED_VALUE( _T( "DEFAULT" ), D3D10_USAGE_DEFAULT )
    NAMED_VALUE( _T( "IMMUTABLE" ), D3D10_USAGE_IMMUTABLE )
    NAMED_VALUE( _T( "DYNAMIC" ), D3D10_USAGE_DYNAMIC )
    NAMED_VALUE( _T( "STAGING" ), D3D10_USAGE_STAGING )
END_NAMED_VALUES( D3D10_USAGE )

//////////////////////////////////////////////////////////////////////////
// Implementation of CD3D10BindFlagValueSet
//////////////////////////////////////////////////////////////////////////

CD3D10BindFlagValueSet::CD3D10BindFlagValueSet( CFilterHandleCommonSource< D3D10_BIND_FLAG > filter )
{
	D3D10_BIND_FLAG D3D10BindFlag;
	
	if( filter.IsValid() )
		filter->SetSource( &D3D10BindFlag );
	
	int count = CD3D10BindFlagInfoMap::GetD3D10BindFlagInfoTableSize();

	for( int i = 0; i < count; i++ )
	{
		D3D10BindFlag = CD3D10BindFlagInfoMap::GetD3D10BindFlagInfo( i ).D3D10BindFlag;
		
		if( !filter.IsValid() || filter->Match() )
			AddValue( D3D10BindFlag );
	}
}


//////////////////////////////////////////////////////////////////////////
// Implementation of CD3D10CpuAccessFlagValueSet
//////////////////////////////////////////////////////////////////////////

CD3D10CpuAccessFlagValueSet::CD3D10CpuAccessFlagValueSet( CFilterHandleCommonSource< D3D10_CPU_ACCESS_FLAG > filter )
{
	D3D10_CPU_ACCESS_FLAG D3D10CpuAccessFlag;
	
	if( filter.IsValid() )
		filter->SetSource( &D3D10CpuAccessFlag );
	
	int count = CD3D10CpuAccessFlagInfoMap::GetD3D10CpuAccessFlagInfoTableSize();

	for( int i = 0; i < count; i++ )
	{
		D3D10CpuAccessFlag = CD3D10CpuAccessFlagInfoMap::GetD3D10CpuAccessFlagInfo( i ).D3D10CpuAccessFlag;
		
		if( !filter.IsValid() || filter->Match() )
			AddValue( D3D10CpuAccessFlag );
	}
}


//////////////////////////////////////////////////////////////////////////
// Implementation of CD3D10ResourceMiscFlagValueSet
//////////////////////////////////////////////////////////////////////////

CD3D10ResourceMiscFlagValueSet::CD3D10ResourceMiscFlagValueSet( CFilterHandleCommonSource< D3D10_RESOURCE_MISC_FLAG > filter )
{
	D3D10_RESOURCE_MISC_FLAG D3D10ResourceMiscFlag;
	
	if( filter.IsValid() )
		filter->SetSource( &D3D10ResourceMiscFlag );
	
	int count = CD3D10ResourceMiscFlagInfoMap::GetD3D10ResourceMiscFlagInfoTableSize();

	for( int i = 0; i < count; i++ )
	{
		D3D10ResourceMiscFlag = CD3D10ResourceMiscFlagInfoMap::GetD3D10ResourceMiscFlagInfo( i ).D3D10ResourceMiscFlag;
		
		if( !filter.IsValid() || filter->Match() )
			AddValue( D3D10ResourceMiscFlag );
	}
}


BEGIN_NAMED_VALUES( D3D10_MAP )
    NAMED_VALUE( _T( "READ" ), D3D10_MAP_READ )
    NAMED_VALUE( _T( "WRITE" ), D3D10_MAP_WRITE )
    NAMED_VALUE( _T( "READ_WRITE" ), D3D10_MAP_READ_WRITE )
    NAMED_VALUE( _T( "WRITE_DISCARD" ), D3D10_MAP_WRITE_DISCARD )
    NAMED_VALUE( _T( "WRITE_NO_OVERWRITE" ), D3D10_MAP_WRITE_NO_OVERWRITE )
END_NAMED_VALUES( D3D10_MAP )

//////////////////////////////////////////////////////////////////////////
// Implementation of CD3D10MapFlagValueSet
//////////////////////////////////////////////////////////////////////////

CD3D10MapFlagValueSet::CD3D10MapFlagValueSet( CFilterHandleCommonSource< D3D10_MAP_FLAG > filter )
{
	D3D10_MAP_FLAG D3D10MapFlag;
	
	if( filter.IsValid() )
		filter->SetSource( &D3D10MapFlag );
	
	int count = CD3D10MapFlagInfoMap::GetD3D10MapFlagInfoTableSize();

	for( int i = 0; i < count; i++ )
	{
		D3D10MapFlag = CD3D10MapFlagInfoMap::GetD3D10MapFlagInfo( i ).D3D10MapFlag;
		
		if( !filter.IsValid() || filter->Match() )
			AddValue( D3D10MapFlag );
	}
}


//////////////////////////////////////////////////////////////////////////
// Implementation of CD3D10RaiseFlagValueSet
//////////////////////////////////////////////////////////////////////////

CD3D10RaiseFlagValueSet::CD3D10RaiseFlagValueSet( CFilterHandleCommonSource< D3D10_RAISE_FLAG > filter )
{
	D3D10_RAISE_FLAG D3D10RaiseFlag;
	
	if( filter.IsValid() )
		filter->SetSource( &D3D10RaiseFlag );
	
	int count = CD3D10RaiseFlagInfoMap::GetD3D10RaiseFlagInfoTableSize();

	for( int i = 0; i < count; i++ )
	{
		D3D10RaiseFlag = CD3D10RaiseFlagInfoMap::GetD3D10RaiseFlagInfo( i ).D3D10RaiseFlag;
		
		if( !filter.IsValid() || filter->Match() )
			AddValue( D3D10RaiseFlag );
	}
}


//////////////////////////////////////////////////////////////////////////
// Implementation of CD3D10ClearFlagValueSet
//////////////////////////////////////////////////////////////////////////

CD3D10ClearFlagValueSet::CD3D10ClearFlagValueSet( CFilterHandleCommonSource< D3D10_CLEAR_FLAG > filter )
{
	D3D10_CLEAR_FLAG D3D10ClearFlag;
	
	if( filter.IsValid() )
		filter->SetSource( &D3D10ClearFlag );
	
	int count = CD3D10ClearFlagInfoMap::GetD3D10ClearFlagInfoTableSize();

	for( int i = 0; i < count; i++ )
	{
		D3D10ClearFlag = CD3D10ClearFlagInfoMap::GetD3D10ClearFlagInfo( i ).D3D10ClearFlag;
		
		if( !filter.IsValid() || filter->Match() )
			AddValue( D3D10ClearFlag );
	}
}


BEGIN_NAMED_VALUES( D3D10_COMPARISON_FUNC )
    NAMED_VALUE( _T( "NEVER" ), D3D10_COMPARISON_NEVER )
    NAMED_VALUE( _T( "LESS" ), D3D10_COMPARISON_LESS )
    NAMED_VALUE( _T( "EQUAL" ), D3D10_COMPARISON_EQUAL )
    NAMED_VALUE( _T( "LESS_EQUAL" ), D3D10_COMPARISON_LESS_EQUAL )
    NAMED_VALUE( _T( "GREATER" ), D3D10_COMPARISON_GREATER )
    NAMED_VALUE( _T( "NOT_EQUAL" ), D3D10_COMPARISON_NOT_EQUAL )
    NAMED_VALUE( _T( "GREATER_EQUAL" ), D3D10_COMPARISON_GREATER_EQUAL )
    NAMED_VALUE( _T( "ALWAYS" ), D3D10_COMPARISON_ALWAYS )
END_NAMED_VALUES( D3D10_COMPARISON_FUNC )

BEGIN_NAMED_VALUES( D3D10_DEPTH_WRITE_MASK )
    NAMED_VALUE( _T( "ZERO" ), D3D10_DEPTH_WRITE_MASK_ZERO )
    NAMED_VALUE( _T( "ALL" ), D3D10_DEPTH_WRITE_MASK_ALL )
END_NAMED_VALUES( D3D10_DEPTH_WRITE_MASK )

BEGIN_NAMED_VALUES( D3D10_STENCIL_OP )
    NAMED_VALUE( _T( "KEEP" ), D3D10_STENCIL_OP_KEEP )
    NAMED_VALUE( _T( "ZERO" ), D3D10_STENCIL_OP_ZERO )
    NAMED_VALUE( _T( "REPLACE" ), D3D10_STENCIL_OP_REPLACE )
    NAMED_VALUE( _T( "INCR_SAT" ), D3D10_STENCIL_OP_INCR_SAT )
    NAMED_VALUE( _T( "DECR_SAT" ), D3D10_STENCIL_OP_DECR_SAT )
    NAMED_VALUE( _T( "INVERT" ), D3D10_STENCIL_OP_INVERT )
    NAMED_VALUE( _T( "INCR" ), D3D10_STENCIL_OP_INCR )
    NAMED_VALUE( _T( "DECR" ), D3D10_STENCIL_OP_DECR )
END_NAMED_VALUES( D3D10_STENCIL_OP )

BEGIN_NAMED_VALUES( D3D10_BLEND )
    NAMED_VALUE( _T( "ZERO" ), D3D10_BLEND_ZERO )
    NAMED_VALUE( _T( "ONE" ), D3D10_BLEND_ONE )
    NAMED_VALUE( _T( "SRC_COLOR" ), D3D10_BLEND_SRC_COLOR )
    NAMED_VALUE( _T( "INV_SRC_COLOR" ), D3D10_BLEND_INV_SRC_COLOR )
    NAMED_VALUE( _T( "SRC_ALPHA" ), D3D10_BLEND_SRC_ALPHA )
    NAMED_VALUE( _T( "INV_SRC_ALPHA" ), D3D10_BLEND_INV_SRC_ALPHA )
    NAMED_VALUE( _T( "DEST_ALPHA" ), D3D10_BLEND_DEST_ALPHA )
    NAMED_VALUE( _T( "INV_DEST_ALPHA" ), D3D10_BLEND_INV_DEST_ALPHA )
    NAMED_VALUE( _T( "DEST_COLOR" ), D3D10_BLEND_DEST_COLOR )
    NAMED_VALUE( _T( "INV_DEST_COLOR" ), D3D10_BLEND_INV_DEST_COLOR )
    NAMED_VALUE( _T( "SRC_ALPHA_SAT" ), D3D10_BLEND_SRC_ALPHA_SAT )
    NAMED_VALUE( _T( "BLEND_FACTOR" ), D3D10_BLEND_BLEND_FACTOR )
    NAMED_VALUE( _T( "INV_BLEND_FACTOR" ), D3D10_BLEND_INV_BLEND_FACTOR )
    NAMED_VALUE( _T( "SRC1_COLOR" ), D3D10_BLEND_SRC1_COLOR )
    NAMED_VALUE( _T( "INV_SRC1_COLOR" ), D3D10_BLEND_INV_SRC1_COLOR )
    NAMED_VALUE( _T( "SRC1_ALPHA" ), D3D10_BLEND_SRC1_ALPHA )
    NAMED_VALUE( _T( "INV_SRC1_ALPHA" ), D3D10_BLEND_INV_SRC1_ALPHA )
END_NAMED_VALUES( D3D10_BLEND )

BEGIN_NAMED_VALUES( D3D10_BLEND_OP )
    NAMED_VALUE( _T( "ADD" ), D3D10_BLEND_OP_ADD )
    NAMED_VALUE( _T( "SUBTRACT" ), D3D10_BLEND_OP_SUBTRACT )
    NAMED_VALUE( _T( "REV_SUBTRACT" ), D3D10_BLEND_OP_REV_SUBTRACT )
    NAMED_VALUE( _T( "MIN" ), D3D10_BLEND_OP_MIN )
    NAMED_VALUE( _T( "MAX" ), D3D10_BLEND_OP_MAX )
END_NAMED_VALUES( D3D10_BLEND_OP )

BEGIN_NAMED_VALUES( D3D10_COLOR_WRITE_ENABLE )
    NAMED_VALUE( _T( "RED" ), D3D10_COLOR_WRITE_ENABLE_RED )
    NAMED_VALUE( _T( "GREEN" ), D3D10_COLOR_WRITE_ENABLE_GREEN )
    NAMED_VALUE( _T( "BLUE" ), D3D10_COLOR_WRITE_ENABLE_BLUE )
    NAMED_VALUE( _T( "ALPHA" ), D3D10_COLOR_WRITE_ENABLE_ALPHA )
    NAMED_VALUE( _T( "ALL" ), D3D10_COLOR_WRITE_ENABLE_ALL )
END_NAMED_VALUES( D3D10_COLOR_WRITE_ENABLE )

BEGIN_NAMED_VALUES( D3D10_TEXTURECUBE_FACE )
    NAMED_VALUE( _T( "POSITIVE_X" ), D3D10_TEXTURECUBE_FACE_POSITIVE_X )
    NAMED_VALUE( _T( "NEGATIVE_X" ), D3D10_TEXTURECUBE_FACE_NEGATIVE_X )
    NAMED_VALUE( _T( "POSITIVE_Y" ), D3D10_TEXTURECUBE_FACE_POSITIVE_Y )
    NAMED_VALUE( _T( "NEGATIVE_Y" ), D3D10_TEXTURECUBE_FACE_NEGATIVE_Y )
    NAMED_VALUE( _T( "POSITIVE_Z" ), D3D10_TEXTURECUBE_FACE_POSITIVE_Z )
    NAMED_VALUE( _T( "NEGATIVE_Z" ), D3D10_TEXTURECUBE_FACE_NEGATIVE_Z )
END_NAMED_VALUES( D3D10_TEXTURECUBE_FACE )

BEGIN_NAMED_VALUES( D3D10_FILTER )
    NAMED_VALUE( _T( "MIN_MAG_MIP_POINT" ), D3D10_FILTER_MIN_MAG_MIP_POINT )
    NAMED_VALUE( _T( "MIN_MAG_POINT_MIP_LINEAR" ), D3D10_FILTER_MIN_MAG_POINT_MIP_LINEAR )
    NAMED_VALUE( _T( "MIN_POINT_MAG_LINEAR_MIP_POINT" ), D3D10_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT )
    NAMED_VALUE( _T( "MIN_POINT_MAG_MIP_LINEAR" ), D3D10_FILTER_MIN_POINT_MAG_MIP_LINEAR )
    NAMED_VALUE( _T( "MIN_LINEAR_MAG_MIP_POINT" ), D3D10_FILTER_MIN_LINEAR_MAG_MIP_POINT )
    NAMED_VALUE( _T( "MIN_LINEAR_MAG_POINT_MIP_LINEAR" ), D3D10_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR )
    NAMED_VALUE( _T( "MIN_MAG_LINEAR_MIP_POINT" ), D3D10_FILTER_MIN_MAG_LINEAR_MIP_POINT )
    NAMED_VALUE( _T( "MIN_MAG_MIP_LINEAR" ), D3D10_FILTER_MIN_MAG_MIP_LINEAR )
    NAMED_VALUE( _T( "ANISOTROPIC" ), D3D10_FILTER_ANISOTROPIC )
    NAMED_VALUE( _T( "COMPARISON_MIN_MAG_MIP_POINT" ), D3D10_FILTER_COMPARISON_MIN_MAG_MIP_POINT )
    NAMED_VALUE( _T( "COMPARISON_MIN_MAG_POINT_MIP_LINEAR" ), D3D10_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR )
    NAMED_VALUE( _T( "COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT" ), D3D10_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT )
    NAMED_VALUE( _T( "COMPARISON_MIN_POINT_MAG_MIP_LINEAR" ), D3D10_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR )
    NAMED_VALUE( _T( "COMPARISON_MIN_LINEAR_MAG_MIP_POINT" ), D3D10_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT )
    NAMED_VALUE( _T( "COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR" ), D3D10_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR )
    NAMED_VALUE( _T( "COMPARISON_MIN_MAG_LINEAR_MIP_POINT" ), D3D10_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT )
    NAMED_VALUE( _T( "COMPARISON_MIN_MAG_MIP_LINEAR" ), D3D10_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR )
    NAMED_VALUE( _T( "COMPARISON_ANISOTROPIC" ), D3D10_FILTER_COMPARISON_ANISOTROPIC )
    NAMED_VALUE( _T( "TEXT_1BIT" ), D3D10_FILTER_TEXT_1BIT )
END_NAMED_VALUES( D3D10_FILTER )

BEGIN_NAMED_VALUES( D3D10_FILTER_TYPE )
    NAMED_VALUE( _T( "POINT" ), D3D10_FILTER_TYPE_POINT )
    NAMED_VALUE( _T( "LINEAR" ), D3D10_FILTER_TYPE_LINEAR )
END_NAMED_VALUES( D3D10_FILTER_TYPE )

BEGIN_NAMED_VALUES( D3D10_TEXTURE_ADDRESS_MODE )
    NAMED_VALUE( _T( "WRAP" ), D3D10_TEXTURE_ADDRESS_WRAP )
    NAMED_VALUE( _T( "MIRROR" ), D3D10_TEXTURE_ADDRESS_MIRROR )
    NAMED_VALUE( _T( "CLAMP" ), D3D10_TEXTURE_ADDRESS_CLAMP )
    NAMED_VALUE( _T( "BORDER" ), D3D10_TEXTURE_ADDRESS_BORDER )
    NAMED_VALUE( _T( "MIRROR_ONCE" ), D3D10_TEXTURE_ADDRESS_MIRROR_ONCE )
END_NAMED_VALUES( D3D10_TEXTURE_ADDRESS_MODE )

BEGIN_NAMED_VALUES( D3D10_FORMAT_SUPPORT )
    NAMED_VALUE( _T( "BUFFER" ), D3D10_FORMAT_SUPPORT_BUFFER )
    NAMED_VALUE( _T( "IA_VERTEX_BUFFER" ), D3D10_FORMAT_SUPPORT_IA_VERTEX_BUFFER )
    NAMED_VALUE( _T( "IA_INDEX_BUFFER" ), D3D10_FORMAT_SUPPORT_IA_INDEX_BUFFER )
    NAMED_VALUE( _T( "SO_BUFFER" ), D3D10_FORMAT_SUPPORT_SO_BUFFER )
    NAMED_VALUE( _T( "TEXTURE1D" ), D3D10_FORMAT_SUPPORT_TEXTURE1D )
    NAMED_VALUE( _T( "TEXTURE2D" ), D3D10_FORMAT_SUPPORT_TEXTURE2D )
    NAMED_VALUE( _T( "TEXTURE3D" ), D3D10_FORMAT_SUPPORT_TEXTURE3D )
    NAMED_VALUE( _T( "TEXTURECUBE" ), D3D10_FORMAT_SUPPORT_TEXTURECUBE )
    NAMED_VALUE( _T( "SHADER_LOAD" ), D3D10_FORMAT_SUPPORT_SHADER_LOAD )
    NAMED_VALUE( _T( "SHADER_SAMPLE" ), D3D10_FORMAT_SUPPORT_SHADER_SAMPLE )
    NAMED_VALUE( _T( "SHADER_SAMPLE_COMPARISON" ), D3D10_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON )
    NAMED_VALUE( _T( "SHADER_SAMPLE_MONO_TEXT" ), D3D10_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT )
    NAMED_VALUE( _T( "MIP" ), D3D10_FORMAT_SUPPORT_MIP )
    NAMED_VALUE( _T( "MIP_AUTOGEN" ), D3D10_FORMAT_SUPPORT_MIP_AUTOGEN )
    NAMED_VALUE( _T( "RENDER_TARGET" ), D3D10_FORMAT_SUPPORT_RENDER_TARGET )
    NAMED_VALUE( _T( "BLENDABLE" ), D3D10_FORMAT_SUPPORT_BLENDABLE )
    NAMED_VALUE( _T( "DEPTH_STENCIL" ), D3D10_FORMAT_SUPPORT_DEPTH_STENCIL )
    NAMED_VALUE( _T( "CPU_LOCKABLE" ), D3D10_FORMAT_SUPPORT_CPU_LOCKABLE )
    NAMED_VALUE( _T( "MULTISAMPLE_RESOLVE" ), D3D10_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE )
    NAMED_VALUE( _T( "DISPLAY" ), D3D10_FORMAT_SUPPORT_DISPLAY )
    NAMED_VALUE( _T( "CAST_WITHIN_BIT_LAYOUT" ), D3D10_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT )
    NAMED_VALUE( _T( "MULTISAMPLE_RENDERTARGET" ), D3D10_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET )
    NAMED_VALUE( _T( "MULTISAMPLE_LOAD" ), D3D10_FORMAT_SUPPORT_MULTISAMPLE_LOAD )
    NAMED_VALUE( _T( "SHADER_GATHER" ), D3D10_FORMAT_SUPPORT_SHADER_GATHER )
    NAMED_VALUE( _T( "BACK_BUFFER_CAST" ), D3D10_FORMAT_SUPPORT_BACK_BUFFER_CAST )
END_NAMED_VALUES( D3D10_FORMAT_SUPPORT )

BEGIN_NAMED_VALUES( D3D10_ASYNC_GETDATA_FLAG )
    NAMED_VALUE( _T( "ASYNC_GETDATA_DONOTFLUSH" ), D3D10_ASYNC_GETDATA_DONOTFLUSH )
END_NAMED_VALUES( D3D10_ASYNC_GETDATA_FLAG )

BEGIN_NAMED_VALUES( D3D10_QUERY )
    NAMED_VALUE( _T( "EVENT" ), D3D10_QUERY_EVENT )
    NAMED_VALUE( _T( "OCCLUSION" ), D3D10_QUERY_OCCLUSION )
    NAMED_VALUE( _T( "TIMESTAMP" ), D3D10_QUERY_TIMESTAMP )
    NAMED_VALUE( _T( "TIMESTAMP_DISJOINT" ), D3D10_QUERY_TIMESTAMP_DISJOINT )
    NAMED_VALUE( _T( "PIPELINE_STATISTICS" ), D3D10_QUERY_PIPELINE_STATISTICS )
    NAMED_VALUE( _T( "OCCLUSION_PREDICATE" ), D3D10_QUERY_OCCLUSION_PREDICATE )
    NAMED_VALUE( _T( "SO_STATISTICS" ), D3D10_QUERY_SO_STATISTICS )
    NAMED_VALUE( _T( "SO_OVERFLOW_PREDICATE" ), D3D10_QUERY_SO_OVERFLOW_PREDICATE )
END_NAMED_VALUES( D3D10_QUERY )

BEGIN_NAMED_VALUES( D3D10_QUERY_MISC_FLAG )
    NAMED_VALUE( _T( "QUERY_MISC_PREDICATEHINT" ), D3D10_QUERY_MISC_PREDICATEHINT )
END_NAMED_VALUES( D3D10_QUERY_MISC_FLAG )

BEGIN_NAMED_VALUES( D3D10_COUNTER )
    NAMED_VALUE( _T( "GPU_IDLE" ), D3D10_COUNTER_GPU_IDLE )
    NAMED_VALUE( _T( "VERTEX_PROCESSING" ), D3D10_COUNTER_VERTEX_PROCESSING )
    NAMED_VALUE( _T( "GEOMETRY_PROCESSING" ), D3D10_COUNTER_GEOMETRY_PROCESSING )
    NAMED_VALUE( _T( "PIXEL_PROCESSING" ), D3D10_COUNTER_PIXEL_PROCESSING )
    NAMED_VALUE( _T( "OTHER_GPU_PROCESSING" ), D3D10_COUNTER_OTHER_GPU_PROCESSING )
    NAMED_VALUE( _T( "HOST_ADAPTER_BANDWIDTH_UTILIZATION" ), D3D10_COUNTER_HOST_ADAPTER_BANDWIDTH_UTILIZATION )
    NAMED_VALUE( _T( "LOCAL_VIDMEM_BANDWIDTH_UTILIZATION" ), D3D10_COUNTER_LOCAL_VIDMEM_BANDWIDTH_UTILIZATION )
    NAMED_VALUE( _T( "VERTEX_THROUGHPUT_UTILIZATION" ), D3D10_COUNTER_VERTEX_THROUGHPUT_UTILIZATION )
    NAMED_VALUE( _T( "TRIANGLE_SETUP_THROUGHPUT_UTILIZATION" ), D3D10_COUNTER_TRIANGLE_SETUP_THROUGHPUT_UTILIZATION )
    NAMED_VALUE( _T( "FILLRATE_THROUGHPUT_UTILIZATION" ), D3D10_COUNTER_FILLRATE_THROUGHPUT_UTILIZATION )
    NAMED_VALUE( _T( "VS_MEMORY_LIMITED" ), D3D10_COUNTER_VS_MEMORY_LIMITED )
    NAMED_VALUE( _T( "VS_COMPUTATION_LIMITED" ), D3D10_COUNTER_VS_COMPUTATION_LIMITED )
    NAMED_VALUE( _T( "GS_MEMORY_LIMITED" ), D3D10_COUNTER_GS_MEMORY_LIMITED )
    NAMED_VALUE( _T( "GS_COMPUTATION_LIMITED" ), D3D10_COUNTER_GS_COMPUTATION_LIMITED )
    NAMED_VALUE( _T( "PS_MEMORY_LIMITED" ), D3D10_COUNTER_PS_MEMORY_LIMITED )
    NAMED_VALUE( _T( "PS_COMPUTATION_LIMITED" ), D3D10_COUNTER_PS_COMPUTATION_LIMITED )
    NAMED_VALUE( _T( "POST_TRANSFORM_CACHE_HIT_RATE" ), D3D10_COUNTER_POST_TRANSFORM_CACHE_HIT_RATE )
    NAMED_VALUE( _T( "TEXTURE_CACHE_HIT_RATE" ), D3D10_COUNTER_TEXTURE_CACHE_HIT_RATE )
    NAMED_VALUE( _T( "DEVICE_DEPENDENT_0" ), D3D10_COUNTER_DEVICE_DEPENDENT_0 )
END_NAMED_VALUES( D3D10_COUNTER )

BEGIN_NAMED_VALUES( D3D10_COUNTER_TYPE )
    NAMED_VALUE( _T( "FLOAT32" ), D3D10_COUNTER_TYPE_FLOAT32 )
    NAMED_VALUE( _T( "UINT16" ), D3D10_COUNTER_TYPE_UINT16 )
    NAMED_VALUE( _T( "UINT32" ), D3D10_COUNTER_TYPE_UINT32 )
    NAMED_VALUE( _T( "UINT64" ), D3D10_COUNTER_TYPE_UINT64 )
END_NAMED_VALUES( D3D10_COUNTER_TYPE )

BEGIN_NAMED_VALUES( D3D10_CREATE_DEVICE_FLAG )
    NAMED_VALUE( _T( "SINGLETHREADED" ), D3D10_CREATE_DEVICE_SINGLETHREADED )
    NAMED_VALUE( _T( "DEBUG" ), D3D10_CREATE_DEVICE_DEBUG )
    NAMED_VALUE( _T( "SWITCH_TO_REF" ), D3D10_CREATE_DEVICE_SWITCH_TO_REF )
    NAMED_VALUE( _T( "PREVENT_INTERNAL_THREADING_OPTIMIZATIONS" ), D3D10_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS )
    NAMED_VALUE( _T( "ALLOW_NULL_FROM_MAP" ), D3D10_CREATE_DEVICE_ALLOW_NULL_FROM_MAP )
    NAMED_VALUE( _T( "BGRA_SUPPORT" ), D3D10_CREATE_DEVICE_BGRA_SUPPORT )
    NAMED_VALUE( _T( "STRICT_VALIDATION" ), D3D10_CREATE_DEVICE_STRICT_VALIDATION )
END_NAMED_VALUES( D3D10_CREATE_DEVICE_FLAG )

BEGIN_NAMED_VALUES( D3D10_MESSAGE_CATEGORY )
    NAMED_VALUE( _T( "APPLICATION_DEFINED" ), D3D10_MESSAGE_CATEGORY_APPLICATION_DEFINED )
    NAMED_VALUE( _T( "MISCELLANEOUS" ), D3D10_MESSAGE_CATEGORY_MISCELLANEOUS )
    NAMED_VALUE( _T( "INITIALIZATION" ), D3D10_MESSAGE_CATEGORY_INITIALIZATION )
    NAMED_VALUE( _T( "CLEANUP" ), D3D10_MESSAGE_CATEGORY_CLEANUP )
    NAMED_VALUE( _T( "COMPILATION" ), D3D10_MESSAGE_CATEGORY_COMPILATION )
    NAMED_VALUE( _T( "STATE_CREATION" ), D3D10_MESSAGE_CATEGORY_STATE_CREATION )
    NAMED_VALUE( _T( "STATE_SETTING" ), D3D10_MESSAGE_CATEGORY_STATE_SETTING )
    NAMED_VALUE( _T( "STATE_GETTING" ), D3D10_MESSAGE_CATEGORY_STATE_GETTING )
    NAMED_VALUE( _T( "RESOURCE_MANIPULATION" ), D3D10_MESSAGE_CATEGORY_RESOURCE_MANIPULATION )
    NAMED_VALUE( _T( "EXECUTION" ), D3D10_MESSAGE_CATEGORY_EXECUTION )
END_NAMED_VALUES( D3D10_MESSAGE_CATEGORY )

BEGIN_NAMED_VALUES( D3D10_MESSAGE_SEVERITY )
    NAMED_VALUE( _T( "CORRUPTION" ), D3D10_MESSAGE_SEVERITY_CORRUPTION )
    NAMED_VALUE( _T( "ERROR" ), D3D10_MESSAGE_SEVERITY_ERROR )
    NAMED_VALUE( _T( "WARNING" ), D3D10_MESSAGE_SEVERITY_WARNING )
    NAMED_VALUE( _T( "INFO" ), D3D10_MESSAGE_SEVERITY_INFO )
END_NAMED_VALUES( D3D10_MESSAGE_SEVERITY )

BEGIN_NAMED_VALUES( D3D10_MESSAGE_ID )
    NAMED_VALUE( _T( "UNKNOWN" ), D3D10_MESSAGE_ID_UNKNOWN )
    NAMED_VALUE( _T( "DEVICE_IASETVERTEXBUFFERS_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_HAZARD )
    NAMED_VALUE( _T( "DEVICE_IASETINDEXBUFFER_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_HAZARD )
    NAMED_VALUE( _T( "DEVICE_VSSETSHADERRESOURCES_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_HAZARD )
    NAMED_VALUE( _T( "DEVICE_VSSETCONSTANTBUFFERS_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_HAZARD )
    NAMED_VALUE( _T( "DEVICE_GSSETSHADERRESOURCES_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_HAZARD )
    NAMED_VALUE( _T( "DEVICE_GSSETCONSTANTBUFFERS_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_HAZARD )
    NAMED_VALUE( _T( "DEVICE_PSSETSHADERRESOURCES_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_HAZARD )
    NAMED_VALUE( _T( "DEVICE_PSSETCONSTANTBUFFERS_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_HAZARD )
    NAMED_VALUE( _T( "DEVICE_OMSETRENDERTARGETS_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_OMSETRENDERTARGETS_HAZARD )
    NAMED_VALUE( _T( "DEVICE_SOSETTARGETS_HAZARD" ), D3D10_MESSAGE_ID_DEVICE_SOSETTARGETS_HAZARD )
    NAMED_VALUE( _T( "STRING_FROM_APPLICATION" ), D3D10_MESSAGE_ID_STRING_FROM_APPLICATION )
    NAMED_VALUE( _T( "CORRUPTED_THIS" ), D3D10_MESSAGE_ID_CORRUPTED_THIS )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER1" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER1 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER2" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER2 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER3" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER3 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER4" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER4 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER5" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER5 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER6" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER6 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER7" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER7 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER8" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER8 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER9" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER9 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER10" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER10 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER11" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER11 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER12" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER12 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER13" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER13 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER14" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER14 )
    NAMED_VALUE( _T( "CORRUPTED_PARAMETER15" ), D3D10_MESSAGE_ID_CORRUPTED_PARAMETER15 )
    NAMED_VALUE( _T( "CORRUPTED_MULTITHREADING" ), D3D10_MESSAGE_ID_CORRUPTED_MULTITHREADING )
    NAMED_VALUE( _T( "MESSAGE_REPORTING_OUTOFMEMORY" ), D3D10_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY )
    NAMED_VALUE( _T( "IASETINPUTLAYOUT_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_IASETINPUTLAYOUT_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "IASETVERTEXBUFFERS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_IASETVERTEXBUFFERS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "IASETINDEXBUFFER_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_IASETINDEXBUFFER_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "VSSETSHADER_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_VSSETSHADER_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "VSSETSHADERRESOURCES_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_VSSETSHADERRESOURCES_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "VSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_VSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "VSSETSAMPLERS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_VSSETSAMPLERS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "GSSETSHADER_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_GSSETSHADER_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "GSSETSHADERRESOURCES_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_GSSETSHADERRESOURCES_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "GSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_GSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "GSSETSAMPLERS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_GSSETSAMPLERS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "SOSETTARGETS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_SOSETTARGETS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "PSSETSHADER_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_PSSETSHADER_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "PSSETSHADERRESOURCES_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_PSSETSHADERRESOURCES_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "PSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_PSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "PSSETSAMPLERS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_PSSETSAMPLERS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "RSSETSTATE_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_RSSETSTATE_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "OMSETBLENDSTATE_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_OMSETBLENDSTATE_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "OMSETDEPTHSTENCILSTATE_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_OMSETDEPTHSTENCILSTATE_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "OMSETRENDERTARGETS_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_OMSETRENDERTARGETS_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "SETPREDICATION_UNBINDDELETINGOBJECT" ), D3D10_MESSAGE_ID_SETPREDICATION_UNBINDDELETINGOBJECT )
    NAMED_VALUE( _T( "GETPRIVATEDATA_MOREDATA" ), D3D10_MESSAGE_ID_GETPRIVATEDATA_MOREDATA )
    NAMED_VALUE( _T( "SETPRIVATEDATA_INVALIDFREEDATA" ), D3D10_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA )
    NAMED_VALUE( _T( "SETPRIVATEDATA_INVALIDIUNKNOWN" ), D3D10_MESSAGE_ID_SETPRIVATEDATA_INVALIDIUNKNOWN )
    NAMED_VALUE( _T( "SETPRIVATEDATA_INVALIDFLAGS" ), D3D10_MESSAGE_ID_SETPRIVATEDATA_INVALIDFLAGS )
    NAMED_VALUE( _T( "SETPRIVATEDATA_CHANGINGPARAMS" ), D3D10_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS )
    NAMED_VALUE( _T( "SETPRIVATEDATA_OUTOFMEMORY" ), D3D10_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY )
    NAMED_VALUE( _T( "CREATEBUFFER_UNRECOGNIZEDFORMAT" ), D3D10_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDFORMAT )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDSAMPLES" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDSAMPLES )
    NAMED_VALUE( _T( "CREATEBUFFER_UNRECOGNIZEDUSAGE" ), D3D10_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDUSAGE )
    NAMED_VALUE( _T( "CREATEBUFFER_UNRECOGNIZEDBINDFLAGS" ), D3D10_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDBINDFLAGS )
    NAMED_VALUE( _T( "CREATEBUFFER_UNRECOGNIZEDCPUACCESSFLAGS" ), D3D10_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDCPUACCESSFLAGS )
    NAMED_VALUE( _T( "CREATEBUFFER_UNRECOGNIZEDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDMISCFLAGS )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDCPUACCESSFLAGS" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDCPUACCESSFLAGS )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDBINDFLAGS" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDBINDFLAGS )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDINITIALDATA" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDINITIALDATA )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDDIMENSIONS" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDDIMENSIONS )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDMIPLEVELS" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDMIPLEVELS )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDMISCFLAGS )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "CREATEBUFFER_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATEBUFFER_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATEBUFFER_NULLDESC" ), D3D10_MESSAGE_ID_CREATEBUFFER_NULLDESC )
    NAMED_VALUE( _T( "CREATEBUFFER_INVALIDCONSTANTBUFFERBINDINGS" ), D3D10_MESSAGE_ID_CREATEBUFFER_INVALIDCONSTANTBUFFERBINDINGS )
    NAMED_VALUE( _T( "CREATEBUFFER_LARGEALLOCATION" ), D3D10_MESSAGE_ID_CREATEBUFFER_LARGEALLOCATION )
    NAMED_VALUE( _T( "CREATETEXTURE1D_UNRECOGNIZEDFORMAT" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDFORMAT )
    NAMED_VALUE( _T( "CREATETEXTURE1D_UNSUPPORTEDFORMAT" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_UNSUPPORTEDFORMAT )
    NAMED_VALUE( _T( "CREATETEXTURE1D_INVALIDSAMPLES" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_INVALIDSAMPLES )
    NAMED_VALUE( _T( "CREATETEXTURE1D_UNRECOGNIZEDUSAGE" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDUSAGE )
    NAMED_VALUE( _T( "CREATETEXTURE1D_UNRECOGNIZEDBINDFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDBINDFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE1D_UNRECOGNIZEDCPUACCESSFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDCPUACCESSFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE1D_UNRECOGNIZEDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDMISCFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE1D_INVALIDCPUACCESSFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_INVALIDCPUACCESSFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE1D_INVALIDBINDFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_INVALIDBINDFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE1D_INVALIDINITIALDATA" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_INVALIDINITIALDATA )
    NAMED_VALUE( _T( "CREATETEXTURE1D_INVALIDDIMENSIONS" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_INVALIDDIMENSIONS )
    NAMED_VALUE( _T( "CREATETEXTURE1D_INVALIDMIPLEVELS" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_INVALIDMIPLEVELS )
    NAMED_VALUE( _T( "CREATETEXTURE1D_INVALIDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_INVALIDMISCFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE1D_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "CREATETEXTURE1D_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATETEXTURE1D_NULLDESC" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_NULLDESC )
    NAMED_VALUE( _T( "CREATETEXTURE1D_LARGEALLOCATION" ), D3D10_MESSAGE_ID_CREATETEXTURE1D_LARGEALLOCATION )
    NAMED_VALUE( _T( "CREATETEXTURE2D_UNRECOGNIZEDFORMAT" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDFORMAT )
    NAMED_VALUE( _T( "CREATETEXTURE2D_UNSUPPORTEDFORMAT" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_UNSUPPORTEDFORMAT )
    NAMED_VALUE( _T( "CREATETEXTURE2D_INVALIDSAMPLES" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_INVALIDSAMPLES )
    NAMED_VALUE( _T( "CREATETEXTURE2D_UNRECOGNIZEDUSAGE" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDUSAGE )
    NAMED_VALUE( _T( "CREATETEXTURE2D_UNRECOGNIZEDBINDFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDBINDFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE2D_UNRECOGNIZEDCPUACCESSFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDCPUACCESSFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE2D_UNRECOGNIZEDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDMISCFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE2D_INVALIDCPUACCESSFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_INVALIDCPUACCESSFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE2D_INVALIDBINDFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_INVALIDBINDFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE2D_INVALIDINITIALDATA" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_INVALIDINITIALDATA )
    NAMED_VALUE( _T( "CREATETEXTURE2D_INVALIDDIMENSIONS" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_INVALIDDIMENSIONS )
    NAMED_VALUE( _T( "CREATETEXTURE2D_INVALIDMIPLEVELS" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_INVALIDMIPLEVELS )
    NAMED_VALUE( _T( "CREATETEXTURE2D_INVALIDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_INVALIDMISCFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE2D_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "CREATETEXTURE2D_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATETEXTURE2D_NULLDESC" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_NULLDESC )
    NAMED_VALUE( _T( "CREATETEXTURE2D_LARGEALLOCATION" ), D3D10_MESSAGE_ID_CREATETEXTURE2D_LARGEALLOCATION )
    NAMED_VALUE( _T( "CREATETEXTURE3D_UNRECOGNIZEDFORMAT" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDFORMAT )
    NAMED_VALUE( _T( "CREATETEXTURE3D_UNSUPPORTEDFORMAT" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_UNSUPPORTEDFORMAT )
    NAMED_VALUE( _T( "CREATETEXTURE3D_INVALIDSAMPLES" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_INVALIDSAMPLES )
    NAMED_VALUE( _T( "CREATETEXTURE3D_UNRECOGNIZEDUSAGE" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDUSAGE )
    NAMED_VALUE( _T( "CREATETEXTURE3D_UNRECOGNIZEDBINDFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDBINDFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE3D_UNRECOGNIZEDCPUACCESSFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDCPUACCESSFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE3D_UNRECOGNIZEDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDMISCFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE3D_INVALIDCPUACCESSFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_INVALIDCPUACCESSFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE3D_INVALIDBINDFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_INVALIDBINDFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE3D_INVALIDINITIALDATA" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_INVALIDINITIALDATA )
    NAMED_VALUE( _T( "CREATETEXTURE3D_INVALIDDIMENSIONS" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_INVALIDDIMENSIONS )
    NAMED_VALUE( _T( "CREATETEXTURE3D_INVALIDMIPLEVELS" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_INVALIDMIPLEVELS )
    NAMED_VALUE( _T( "CREATETEXTURE3D_INVALIDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_INVALIDMISCFLAGS )
    NAMED_VALUE( _T( "CREATETEXTURE3D_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "CREATETEXTURE3D_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATETEXTURE3D_NULLDESC" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_NULLDESC )
    NAMED_VALUE( _T( "CREATETEXTURE3D_LARGEALLOCATION" ), D3D10_MESSAGE_ID_CREATETEXTURE3D_LARGEALLOCATION )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_INVALIDDESC" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_INVALIDFORMAT" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_INVALIDRESOURCE" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_TOOMANYOBJECTS" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_TOOMANYOBJECTS )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_INVALIDDESC" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_INVALIDFORMAT" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_INVALIDDIMENSIONS" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_INVALIDRESOURCE" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_TOOMANYOBJECTS" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_TOOMANYOBJECTS )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILVIEW_INVALIDDESC" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILVIEW_INVALIDFORMAT" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILVIEW_TOOMANYOBJECTS" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_TOOMANYOBJECTS )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_OUTOFMEMORY" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_TOOMANYELEMENTS" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_INVALIDFORMAT" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_INVALIDSLOT" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_INVALIDALIGNMENT" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_DUPLICATESEMANTIC" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_NULLSEMANTIC" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_MISSINGELEMENT" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_NULLDESC" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_NULLDESC )
    NAMED_VALUE( _T( "CREATEVERTEXSHADER_OUTOFMEMORY" ), D3D10_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY )
    NAMED_VALUE( _T( "CREATEVERTEXSHADER_INVALIDSHADERBYTECODE" ), D3D10_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE )
    NAMED_VALUE( _T( "CREATEVERTEXSHADER_INVALIDSHADERTYPE" ), D3D10_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADER_OUTOFMEMORY" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADER_INVALIDSHADERTYPE" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE )
    NAMED_VALUE( _T( "CREATEPIXELSHADER_OUTOFMEMORY" ), D3D10_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY )
    NAMED_VALUE( _T( "CREATEPIXELSHADER_INVALIDSHADERBYTECODE" ), D3D10_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE )
    NAMED_VALUE( _T( "CREATEPIXELSHADER_INVALIDSHADERTYPE" ), D3D10_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE )
    NAMED_VALUE( _T( "CREATERASTERIZERSTATE_INVALIDFILLMODE" ), D3D10_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE )
    NAMED_VALUE( _T( "CREATERASTERIZERSTATE_INVALIDCULLMODE" ), D3D10_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE )
    NAMED_VALUE( _T( "CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP" ), D3D10_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP )
    NAMED_VALUE( _T( "CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS" ), D3D10_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS )
    NAMED_VALUE( _T( "CREATERASTERIZERSTATE_TOOMANYOBJECTS" ), D3D10_MESSAGE_ID_CREATERASTERIZERSTATE_TOOMANYOBJECTS )
    NAMED_VALUE( _T( "CREATERASTERIZERSTATE_NULLDESC" ), D3D10_MESSAGE_ID_CREATERASTERIZERSTATE_NULLDESC )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_TOOMANYOBJECTS" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_TOOMANYOBJECTS )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_NULLDESC" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_NULLDESC )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_INVALIDSRCBLEND" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_INVALIDDESTBLEND" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_INVALIDBLENDOP" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_INVALIDSRCBLENDALPHA" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_INVALIDDESTBLENDALPHA" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_INVALIDBLENDOPALPHA" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_TOOMANYOBJECTS" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_TOOMANYOBJECTS )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_NULLDESC" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_NULLDESC )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDFILTER" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDFILTER )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDADDRESSU" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSU )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDADDRESSV" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSV )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDADDRESSW" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSW )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDMIPLODBIAS" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMIPLODBIAS )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDMAXANISOTROPY" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXANISOTROPY )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDMINLOD" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMINLOD )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_INVALIDMAXLOD" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXLOD )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_TOOMANYOBJECTS" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_TOOMANYOBJECTS )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_NULLDESC" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_NULLDESC )
    NAMED_VALUE( _T( "CREATEQUERYORPREDICATE_INVALIDQUERY" ), D3D10_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDQUERY )
    NAMED_VALUE( _T( "CREATEQUERYORPREDICATE_INVALIDMISCFLAGS" ), D3D10_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDMISCFLAGS )
    NAMED_VALUE( _T( "CREATEQUERYORPREDICATE_UNEXPECTEDMISCFLAG" ), D3D10_MESSAGE_ID_CREATEQUERYORPREDICATE_UNEXPECTEDMISCFLAG )
    NAMED_VALUE( _T( "CREATEQUERYORPREDICATE_NULLDESC" ), D3D10_MESSAGE_ID_CREATEQUERYORPREDICATE_NULLDESC )
    NAMED_VALUE( _T( "DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED" ), D3D10_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED )
    NAMED_VALUE( _T( "DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED" ), D3D10_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED )
    NAMED_VALUE( _T( "IASETVERTEXBUFFERS_INVALIDBUFFER" ), D3D10_MESSAGE_ID_IASETVERTEXBUFFERS_INVALIDBUFFER )
    NAMED_VALUE( _T( "DEVICE_IASETVERTEXBUFFERS_OFFSET_TOO_LARGE" ), D3D10_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_OFFSET_TOO_LARGE )
    NAMED_VALUE( _T( "DEVICE_IASETVERTEXBUFFERS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "IASETINDEXBUFFER_INVALIDBUFFER" ), D3D10_MESSAGE_ID_IASETINDEXBUFFER_INVALIDBUFFER )
    NAMED_VALUE( _T( "DEVICE_IASETINDEXBUFFER_FORMAT_INVALID" ), D3D10_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_FORMAT_INVALID )
    NAMED_VALUE( _T( "DEVICE_IASETINDEXBUFFER_OFFSET_TOO_LARGE" ), D3D10_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_TOO_LARGE )
    NAMED_VALUE( _T( "DEVICE_IASETINDEXBUFFER_OFFSET_UNALIGNED" ), D3D10_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_UNALIGNED )
    NAMED_VALUE( _T( "DEVICE_VSSETSHADERRESOURCES_VIEWS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_VIEWS_EMPTY )
    NAMED_VALUE( _T( "VSSETCONSTANTBUFFERS_INVALIDBUFFER" ), D3D10_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFER )
    NAMED_VALUE( _T( "DEVICE_VSSETCONSTANTBUFFERS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_VSSETSAMPLERS_SAMPLERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_VSSETSAMPLERS_SAMPLERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_GSSETSHADERRESOURCES_VIEWS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_VIEWS_EMPTY )
    NAMED_VALUE( _T( "GSSETCONSTANTBUFFERS_INVALIDBUFFER" ), D3D10_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFER )
    NAMED_VALUE( _T( "DEVICE_GSSETCONSTANTBUFFERS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_GSSETSAMPLERS_SAMPLERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_GSSETSAMPLERS_SAMPLERS_EMPTY )
    NAMED_VALUE( _T( "SOSETTARGETS_INVALIDBUFFER" ), D3D10_MESSAGE_ID_SOSETTARGETS_INVALIDBUFFER )
    NAMED_VALUE( _T( "DEVICE_SOSETTARGETS_OFFSET_UNALIGNED" ), D3D10_MESSAGE_ID_DEVICE_SOSETTARGETS_OFFSET_UNALIGNED )
    NAMED_VALUE( _T( "DEVICE_PSSETSHADERRESOURCES_VIEWS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_VIEWS_EMPTY )
    NAMED_VALUE( _T( "PSSETCONSTANTBUFFERS_INVALIDBUFFER" ), D3D10_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFER )
    NAMED_VALUE( _T( "DEVICE_PSSETCONSTANTBUFFERS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_PSSETSAMPLERS_SAMPLERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_PSSETSAMPLERS_SAMPLERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT" ), D3D10_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT )
    NAMED_VALUE( _T( "DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR" ), D3D10_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR )
    NAMED_VALUE( _T( "CLEARRENDERTARGETVIEW_DENORMFLUSH" ), D3D10_MESSAGE_ID_CLEARRENDERTARGETVIEW_DENORMFLUSH )
    NAMED_VALUE( _T( "CLEARDEPTHSTENCILVIEW_DENORMFLUSH" ), D3D10_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DENORMFLUSH )
    NAMED_VALUE( _T( "CLEARDEPTHSTENCILVIEW_INVALID" ), D3D10_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID )
    NAMED_VALUE( _T( "DEVICE_IAGETVERTEXBUFFERS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_IAGETVERTEXBUFFERS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_VSGETSHADERRESOURCES_VIEWS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_VSGETSHADERRESOURCES_VIEWS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_VSGETCONSTANTBUFFERS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_VSGETCONSTANTBUFFERS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_VSGETSAMPLERS_SAMPLERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_VSGETSAMPLERS_SAMPLERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_GSGETSHADERRESOURCES_VIEWS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_GSGETSHADERRESOURCES_VIEWS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_GSGETCONSTANTBUFFERS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_GSGETCONSTANTBUFFERS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_GSGETSAMPLERS_SAMPLERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_GSGETSAMPLERS_SAMPLERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_SOGETTARGETS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_SOGETTARGETS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_PSGETSHADERRESOURCES_VIEWS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_PSGETSHADERRESOURCES_VIEWS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_PSGETCONSTANTBUFFERS_BUFFERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_PSGETCONSTANTBUFFERS_BUFFERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_PSGETSAMPLERS_SAMPLERS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_PSGETSAMPLERS_SAMPLERS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_RSGETVIEWPORTS_VIEWPORTS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_RSGETVIEWPORTS_VIEWPORTS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_RSGETSCISSORRECTS_RECTS_EMPTY" ), D3D10_MESSAGE_ID_DEVICE_RSGETSCISSORRECTS_RECTS_EMPTY )
    NAMED_VALUE( _T( "DEVICE_GENERATEMIPS_RESOURCE_INVALID" ), D3D10_MESSAGE_ID_DEVICE_GENERATEMIPS_RESOURCE_INVALID )
    NAMED_VALUE( _T( "COPYSUBRESOURCEREGION_INVALIDDESTINATIONSUBRESOURCE" ), D3D10_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSUBRESOURCE )
    NAMED_VALUE( _T( "COPYSUBRESOURCEREGION_INVALIDSOURCESUBRESOURCE" ), D3D10_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESUBRESOURCE )
    NAMED_VALUE( _T( "COPYSUBRESOURCEREGION_INVALIDSOURCEBOX" ), D3D10_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCEBOX )
    NAMED_VALUE( _T( "COPYSUBRESOURCEREGION_INVALIDSOURCE" ), D3D10_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCE )
    NAMED_VALUE( _T( "COPYSUBRESOURCEREGION_INVALIDDESTINATIONSTATE" ), D3D10_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSTATE )
    NAMED_VALUE( _T( "COPYSUBRESOURCEREGION_INVALIDSOURCESTATE" ), D3D10_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESTATE )
    NAMED_VALUE( _T( "COPYRESOURCE_INVALIDSOURCE" ), D3D10_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCE )
    NAMED_VALUE( _T( "COPYRESOURCE_INVALIDDESTINATIONSTATE" ), D3D10_MESSAGE_ID_COPYRESOURCE_INVALIDDESTINATIONSTATE )
    NAMED_VALUE( _T( "COPYRESOURCE_INVALIDSOURCESTATE" ), D3D10_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCESTATE )
    NAMED_VALUE( _T( "UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE" ), D3D10_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE )
    NAMED_VALUE( _T( "UPDATESUBRESOURCE_INVALIDDESTINATIONBOX" ), D3D10_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONBOX )
    NAMED_VALUE( _T( "UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE" ), D3D10_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE )
    NAMED_VALUE( _T( "DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID" ), D3D10_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID )
    NAMED_VALUE( _T( "DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID" ), D3D10_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID )
    NAMED_VALUE( _T( "DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID" ), D3D10_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID )
    NAMED_VALUE( _T( "DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID" ), D3D10_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID )
    NAMED_VALUE( _T( "DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID" ), D3D10_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID )
    NAMED_VALUE( _T( "BUFFER_MAP_INVALIDMAPTYPE" ), D3D10_MESSAGE_ID_BUFFER_MAP_INVALIDMAPTYPE )
    NAMED_VALUE( _T( "BUFFER_MAP_INVALIDFLAGS" ), D3D10_MESSAGE_ID_BUFFER_MAP_INVALIDFLAGS )
    NAMED_VALUE( _T( "BUFFER_MAP_ALREADYMAPPED" ), D3D10_MESSAGE_ID_BUFFER_MAP_ALREADYMAPPED )
    NAMED_VALUE( _T( "BUFFER_MAP_DEVICEREMOVED_RETURN" ), D3D10_MESSAGE_ID_BUFFER_MAP_DEVICEREMOVED_RETURN )
    NAMED_VALUE( _T( "BUFFER_UNMAP_NOTMAPPED" ), D3D10_MESSAGE_ID_BUFFER_UNMAP_NOTMAPPED )
    NAMED_VALUE( _T( "TEXTURE1D_MAP_INVALIDMAPTYPE" ), D3D10_MESSAGE_ID_TEXTURE1D_MAP_INVALIDMAPTYPE )
    NAMED_VALUE( _T( "TEXTURE1D_MAP_INVALIDSUBRESOURCE" ), D3D10_MESSAGE_ID_TEXTURE1D_MAP_INVALIDSUBRESOURCE )
    NAMED_VALUE( _T( "TEXTURE1D_MAP_INVALIDFLAGS" ), D3D10_MESSAGE_ID_TEXTURE1D_MAP_INVALIDFLAGS )
    NAMED_VALUE( _T( "TEXTURE1D_MAP_ALREADYMAPPED" ), D3D10_MESSAGE_ID_TEXTURE1D_MAP_ALREADYMAPPED )
    NAMED_VALUE( _T( "TEXTURE1D_MAP_DEVICEREMOVED_RETURN" ), D3D10_MESSAGE_ID_TEXTURE1D_MAP_DEVICEREMOVED_RETURN )
    NAMED_VALUE( _T( "TEXTURE1D_UNMAP_INVALIDSUBRESOURCE" ), D3D10_MESSAGE_ID_TEXTURE1D_UNMAP_INVALIDSUBRESOURCE )
    NAMED_VALUE( _T( "TEXTURE1D_UNMAP_NOTMAPPED" ), D3D10_MESSAGE_ID_TEXTURE1D_UNMAP_NOTMAPPED )
    NAMED_VALUE( _T( "TEXTURE2D_MAP_INVALIDMAPTYPE" ), D3D10_MESSAGE_ID_TEXTURE2D_MAP_INVALIDMAPTYPE )
    NAMED_VALUE( _T( "TEXTURE2D_MAP_INVALIDSUBRESOURCE" ), D3D10_MESSAGE_ID_TEXTURE2D_MAP_INVALIDSUBRESOURCE )
    NAMED_VALUE( _T( "TEXTURE2D_MAP_INVALIDFLAGS" ), D3D10_MESSAGE_ID_TEXTURE2D_MAP_INVALIDFLAGS )
    NAMED_VALUE( _T( "TEXTURE2D_MAP_ALREADYMAPPED" ), D3D10_MESSAGE_ID_TEXTURE2D_MAP_ALREADYMAPPED )
    NAMED_VALUE( _T( "TEXTURE2D_MAP_DEVICEREMOVED_RETURN" ), D3D10_MESSAGE_ID_TEXTURE2D_MAP_DEVICEREMOVED_RETURN )
    NAMED_VALUE( _T( "TEXTURE2D_UNMAP_INVALIDSUBRESOURCE" ), D3D10_MESSAGE_ID_TEXTURE2D_UNMAP_INVALIDSUBRESOURCE )
    NAMED_VALUE( _T( "TEXTURE2D_UNMAP_NOTMAPPED" ), D3D10_MESSAGE_ID_TEXTURE2D_UNMAP_NOTMAPPED )
    NAMED_VALUE( _T( "TEXTURE3D_MAP_INVALIDMAPTYPE" ), D3D10_MESSAGE_ID_TEXTURE3D_MAP_INVALIDMAPTYPE )
    NAMED_VALUE( _T( "TEXTURE3D_MAP_INVALIDSUBRESOURCE" ), D3D10_MESSAGE_ID_TEXTURE3D_MAP_INVALIDSUBRESOURCE )
    NAMED_VALUE( _T( "TEXTURE3D_MAP_INVALIDFLAGS" ), D3D10_MESSAGE_ID_TEXTURE3D_MAP_INVALIDFLAGS )
    NAMED_VALUE( _T( "TEXTURE3D_MAP_ALREADYMAPPED" ), D3D10_MESSAGE_ID_TEXTURE3D_MAP_ALREADYMAPPED )
    NAMED_VALUE( _T( "TEXTURE3D_MAP_DEVICEREMOVED_RETURN" ), D3D10_MESSAGE_ID_TEXTURE3D_MAP_DEVICEREMOVED_RETURN )
    NAMED_VALUE( _T( "TEXTURE3D_UNMAP_INVALIDSUBRESOURCE" ), D3D10_MESSAGE_ID_TEXTURE3D_UNMAP_INVALIDSUBRESOURCE )
    NAMED_VALUE( _T( "TEXTURE3D_UNMAP_NOTMAPPED" ), D3D10_MESSAGE_ID_TEXTURE3D_UNMAP_NOTMAPPED )
    NAMED_VALUE( _T( "CHECKFORMATSUPPORT_FORMAT_DEPRECATED" ), D3D10_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_DEPRECATED )
    NAMED_VALUE( _T( "CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED" ), D3D10_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED )
    NAMED_VALUE( _T( "SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS" ), D3D10_MESSAGE_ID_SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS )
    NAMED_VALUE( _T( "SETEXCEPTIONMODE_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_SETEXCEPTIONMODE_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "SETEXCEPTIONMODE_DEVICEREMOVED_RETURN" ), D3D10_MESSAGE_ID_SETEXCEPTIONMODE_DEVICEREMOVED_RETURN )
    NAMED_VALUE( _T( "REF_SIMULATING_INFINITELY_FAST_HARDWARE" ), D3D10_MESSAGE_ID_REF_SIMULATING_INFINITELY_FAST_HARDWARE )
    NAMED_VALUE( _T( "REF_THREADING_MODE" ), D3D10_MESSAGE_ID_REF_THREADING_MODE )
    NAMED_VALUE( _T( "REF_UMDRIVER_EXCEPTION" ), D3D10_MESSAGE_ID_REF_UMDRIVER_EXCEPTION )
    NAMED_VALUE( _T( "REF_KMDRIVER_EXCEPTION" ), D3D10_MESSAGE_ID_REF_KMDRIVER_EXCEPTION )
    NAMED_VALUE( _T( "REF_HARDWARE_EXCEPTION" ), D3D10_MESSAGE_ID_REF_HARDWARE_EXCEPTION )
    NAMED_VALUE( _T( "REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE" ), D3D10_MESSAGE_ID_REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE )
    NAMED_VALUE( _T( "REF_PROBLEM_PARSING_SHADER" ), D3D10_MESSAGE_ID_REF_PROBLEM_PARSING_SHADER )
    NAMED_VALUE( _T( "REF_OUT_OF_MEMORY" ), D3D10_MESSAGE_ID_REF_OUT_OF_MEMORY )
    NAMED_VALUE( _T( "REF_INFO" ), D3D10_MESSAGE_ID_REF_INFO )
    NAMED_VALUE( _T( "DEVICE_DRAW_VERTEXPOS_OVERFLOW" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VERTEXPOS_OVERFLOW )
    NAMED_VALUE( _T( "DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW" ), D3D10_MESSAGE_ID_DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW )
    NAMED_VALUE( _T( "DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW" ), D3D10_MESSAGE_ID_DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW )
    NAMED_VALUE( _T( "DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW" ), D3D10_MESSAGE_ID_DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW )
    NAMED_VALUE( _T( "DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW" ), D3D10_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW )
    NAMED_VALUE( _T( "DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW" ), D3D10_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW )
    NAMED_VALUE( _T( "DEVICE_DRAW_VERTEX_SHADER_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VERTEX_SHADER_NOT_SET )
    NAMED_VALUE( _T( "DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND" ), D3D10_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND )
    NAMED_VALUE( _T( "DEVICE_SHADER_LINKAGE_REGISTERINDEX" ), D3D10_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERINDEX )
    NAMED_VALUE( _T( "DEVICE_SHADER_LINKAGE_COMPONENTTYPE" ), D3D10_MESSAGE_ID_DEVICE_SHADER_LINKAGE_COMPONENTTYPE )
    NAMED_VALUE( _T( "DEVICE_SHADER_LINKAGE_REGISTERMASK" ), D3D10_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERMASK )
    NAMED_VALUE( _T( "DEVICE_SHADER_LINKAGE_SYSTEMVALUE" ), D3D10_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SYSTEMVALUE )
    NAMED_VALUE( _T( "DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS" ), D3D10_MESSAGE_ID_DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS )
    NAMED_VALUE( _T( "DEVICE_DRAW_VERTEX_BUFFER_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_NOT_SET )
    NAMED_VALUE( _T( "DEVICE_DRAW_INPUTLAYOUT_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_INPUTLAYOUT_NOT_SET )
    NAMED_VALUE( _T( "DEVICE_DRAW_CONSTANT_BUFFER_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_NOT_SET )
    NAMED_VALUE( _T( "DEVICE_DRAW_CONSTANT_BUFFER_TOO_SMALL" ), D3D10_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_TOO_SMALL )
    NAMED_VALUE( _T( "DEVICE_DRAW_SAMPLER_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_SAMPLER_NOT_SET )
    NAMED_VALUE( _T( "DEVICE_DRAW_SHADERRESOURCEVIEW_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_SHADERRESOURCEVIEW_NOT_SET )
    NAMED_VALUE( _T( "DEVICE_DRAW_VIEW_DIMENSION_MISMATCH" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VIEW_DIMENSION_MISMATCH )
    NAMED_VALUE( _T( "DEVICE_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL )
    NAMED_VALUE( _T( "DEVICE_DRAW_VERTEX_BUFFER_TOO_SMALL" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_TOO_SMALL )
    NAMED_VALUE( _T( "DEVICE_DRAW_INDEX_BUFFER_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_NOT_SET )
    NAMED_VALUE( _T( "DEVICE_DRAW_INDEX_BUFFER_FORMAT_INVALID" ), D3D10_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_FORMAT_INVALID )
    NAMED_VALUE( _T( "DEVICE_DRAW_INDEX_BUFFER_TOO_SMALL" ), D3D10_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_TOO_SMALL )
    NAMED_VALUE( _T( "DEVICE_DRAW_GS_INPUT_PRIMITIVE_MISMATCH" ), D3D10_MESSAGE_ID_DEVICE_DRAW_GS_INPUT_PRIMITIVE_MISMATCH )
    NAMED_VALUE( _T( "DEVICE_DRAW_RESOURCE_RETURN_TYPE_MISMATCH" ), D3D10_MESSAGE_ID_DEVICE_DRAW_RESOURCE_RETURN_TYPE_MISMATCH )
    NAMED_VALUE( _T( "DEVICE_DRAW_POSITION_NOT_PRESENT" ), D3D10_MESSAGE_ID_DEVICE_DRAW_POSITION_NOT_PRESENT )
    NAMED_VALUE( _T( "DEVICE_DRAW_OUTPUT_STREAM_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_NOT_SET )
    NAMED_VALUE( _T( "DEVICE_DRAW_BOUND_RESOURCE_MAPPED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_BOUND_RESOURCE_MAPPED )
    NAMED_VALUE( _T( "DEVICE_DRAW_INVALID_PRIMITIVETOPOLOGY" ), D3D10_MESSAGE_ID_DEVICE_DRAW_INVALID_PRIMITIVETOPOLOGY )
    NAMED_VALUE( _T( "DEVICE_DRAW_VERTEX_OFFSET_UNALIGNED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VERTEX_OFFSET_UNALIGNED )
    NAMED_VALUE( _T( "DEVICE_DRAW_VERTEX_STRIDE_UNALIGNED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VERTEX_STRIDE_UNALIGNED )
    NAMED_VALUE( _T( "DEVICE_DRAW_INDEX_OFFSET_UNALIGNED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_INDEX_OFFSET_UNALIGNED )
    NAMED_VALUE( _T( "DEVICE_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED )
    NAMED_VALUE( _T( "DEVICE_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED )
    NAMED_VALUE( _T( "DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED )
    NAMED_VALUE( _T( "DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED )
    NAMED_VALUE( _T( "DEVICE_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED )
    NAMED_VALUE( _T( "DEVICE_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE" ), D3D10_MESSAGE_ID_DEVICE_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE )
    NAMED_VALUE( _T( "DEVICE_DRAW_SO_STRIDE_LARGER_THAN_BUFFER" ), D3D10_MESSAGE_ID_DEVICE_DRAW_SO_STRIDE_LARGER_THAN_BUFFER )
    NAMED_VALUE( _T( "DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING" ), D3D10_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING )
    NAMED_VALUE( _T( "DEVICE_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0" ), D3D10_MESSAGE_ID_DEVICE_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0 )
    NAMED_VALUE( _T( "DEVICE_REMOVAL_PROCESS_AT_FAULT" ), D3D10_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT )
    NAMED_VALUE( _T( "DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT" ), D3D10_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT )
    NAMED_VALUE( _T( "DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT" ), D3D10_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT )
    NAMED_VALUE( _T( "DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN" ), D3D10_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN )
    NAMED_VALUE( _T( "DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN" ), D3D10_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN )
    NAMED_VALUE( _T( "DEVICE_DRAW_VIEWPORT_NOT_SET" ), D3D10_MESSAGE_ID_DEVICE_DRAW_VIEWPORT_NOT_SET )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC )
    NAMED_VALUE( _T( "CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC" ), D3D10_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC )
    NAMED_VALUE( _T( "DEVICE_RSSETVIEWPORTS_DENORMFLUSH" ), D3D10_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_DENORMFLUSH )
    NAMED_VALUE( _T( "OMSETRENDERTARGETS_INVALIDVIEW" ), D3D10_MESSAGE_ID_OMSETRENDERTARGETS_INVALIDVIEW )
    NAMED_VALUE( _T( "DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS" ), D3D10_MESSAGE_ID_DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS )
    NAMED_VALUE( _T( "DEVICE_DRAW_SAMPLER_MISMATCH" ), D3D10_MESSAGE_ID_DEVICE_DRAW_SAMPLER_MISMATCH )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_TYPE_MISMATCH" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH )
    NAMED_VALUE( _T( "BLENDSTATE_GETDESC_LEGACY" ), D3D10_MESSAGE_ID_BLENDSTATE_GETDESC_LEGACY )
    NAMED_VALUE( _T( "SHADERRESOURCEVIEW_GETDESC_LEGACY" ), D3D10_MESSAGE_ID_SHADERRESOURCEVIEW_GETDESC_LEGACY )
    NAMED_VALUE( _T( "CREATEQUERY_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATEQUERY_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATEPREDICATE_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATEPREDICATE_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATECOUNTER_OUTOFRANGE_COUNTER" ), D3D10_MESSAGE_ID_CREATECOUNTER_OUTOFRANGE_COUNTER )
    NAMED_VALUE( _T( "CREATECOUNTER_SIMULTANEOUS_ACTIVE_COUNTERS_EXHAUSTED" ), D3D10_MESSAGE_ID_CREATECOUNTER_SIMULTANEOUS_ACTIVE_COUNTERS_EXHAUSTED )
    NAMED_VALUE( _T( "CREATECOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER" ), D3D10_MESSAGE_ID_CREATECOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER )
    NAMED_VALUE( _T( "CREATECOUNTER_OUTOFMEMORY_RETURN" ), D3D10_MESSAGE_ID_CREATECOUNTER_OUTOFMEMORY_RETURN )
    NAMED_VALUE( _T( "CREATECOUNTER_NONEXCLUSIVE_RETURN" ), D3D10_MESSAGE_ID_CREATECOUNTER_NONEXCLUSIVE_RETURN )
    NAMED_VALUE( _T( "CREATECOUNTER_NULLDESC" ), D3D10_MESSAGE_ID_CREATECOUNTER_NULLDESC )
    NAMED_VALUE( _T( "CHECKCOUNTER_OUTOFRANGE_COUNTER" ), D3D10_MESSAGE_ID_CHECKCOUNTER_OUTOFRANGE_COUNTER )
    NAMED_VALUE( _T( "CHECKCOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER" ), D3D10_MESSAGE_ID_CHECKCOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER )
    NAMED_VALUE( _T( "SETPREDICATION_INVALID_PREDICATE_STATE" ), D3D10_MESSAGE_ID_SETPREDICATION_INVALID_PREDICATE_STATE )
    NAMED_VALUE( _T( "QUERY_BEGIN_UNSUPPORTED" ), D3D10_MESSAGE_ID_QUERY_BEGIN_UNSUPPORTED )
    NAMED_VALUE( _T( "PREDICATE_BEGIN_DURING_PREDICATION" ), D3D10_MESSAGE_ID_PREDICATE_BEGIN_DURING_PREDICATION )
    NAMED_VALUE( _T( "QUERY_BEGIN_DUPLICATE" ), D3D10_MESSAGE_ID_QUERY_BEGIN_DUPLICATE )
    NAMED_VALUE( _T( "QUERY_BEGIN_ABANDONING_PREVIOUS_RESULTS" ), D3D10_MESSAGE_ID_QUERY_BEGIN_ABANDONING_PREVIOUS_RESULTS )
    NAMED_VALUE( _T( "PREDICATE_END_DURING_PREDICATION" ), D3D10_MESSAGE_ID_PREDICATE_END_DURING_PREDICATION )
    NAMED_VALUE( _T( "QUERY_END_ABANDONING_PREVIOUS_RESULTS" ), D3D10_MESSAGE_ID_QUERY_END_ABANDONING_PREVIOUS_RESULTS )
    NAMED_VALUE( _T( "QUERY_END_WITHOUT_BEGIN" ), D3D10_MESSAGE_ID_QUERY_END_WITHOUT_BEGIN )
    NAMED_VALUE( _T( "QUERY_GETDATA_INVALID_DATASIZE" ), D3D10_MESSAGE_ID_QUERY_GETDATA_INVALID_DATASIZE )
    NAMED_VALUE( _T( "QUERY_GETDATA_INVALID_FLAGS" ), D3D10_MESSAGE_ID_QUERY_GETDATA_INVALID_FLAGS )
    NAMED_VALUE( _T( "QUERY_GETDATA_INVALID_CALL" ), D3D10_MESSAGE_ID_QUERY_GETDATA_INVALID_CALL )
    NAMED_VALUE( _T( "DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH" ), D3D10_MESSAGE_ID_DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH )
    NAMED_VALUE( _T( "DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED" ), D3D10_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED )
    NAMED_VALUE( _T( "DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN" ), D3D10_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN )
    NAMED_VALUE( _T( "DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE" ), D3D10_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE )
    NAMED_VALUE( _T( "DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE" ), D3D10_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_EMPTY_LAYOUT" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT )
    NAMED_VALUE( _T( "DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH" ), D3D10_MESSAGE_ID_DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH )
    NAMED_VALUE( _T( "D3D10_MESSAGES_END" ), D3D10_MESSAGE_ID_D3D10_MESSAGES_END )
    NAMED_VALUE( _T( "D3D10L9_MESSAGES_START" ), D3D10_MESSAGE_ID_D3D10L9_MESSAGES_START )
    NAMED_VALUE( _T( "CREATEDEPTHSTENCILSTATE_STENCIL_NO_TWO_SIDED" ), D3D10_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_STENCIL_NO_TWO_SIDED )
    NAMED_VALUE( _T( "CREATERASTERIZERSTATE_DepthBiasClamp_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_CREATERASTERIZERSTATE_DepthBiasClamp_NOT_SUPPORTED )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_NO_COMPARISON_SUPPORT" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_NO_COMPARISON_SUPPORT )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_EXCESSIVE_ANISOTROPY" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_EXCESSIVE_ANISOTROPY )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_BORDER_OUT_OF_RANGE" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_OUT_OF_RANGE )
    NAMED_VALUE( _T( "VSSETSAMPLERS_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_VSSETSAMPLERS_NOT_SUPPORTED )
    NAMED_VALUE( _T( "VSSETSAMPLERS_TOO_MANY_SAMPLERS" ), D3D10_MESSAGE_ID_VSSETSAMPLERS_TOO_MANY_SAMPLERS )
    NAMED_VALUE( _T( "PSSETSAMPLERS_TOO_MANY_SAMPLERS" ), D3D10_MESSAGE_ID_PSSETSAMPLERS_TOO_MANY_SAMPLERS )
    NAMED_VALUE( _T( "CREATERESOURCE_NO_ARRAYS" ), D3D10_MESSAGE_ID_CREATERESOURCE_NO_ARRAYS )
    NAMED_VALUE( _T( "CREATERESOURCE_NO_VB_AND_IB_BIND" ), D3D10_MESSAGE_ID_CREATERESOURCE_NO_VB_AND_IB_BIND )
    NAMED_VALUE( _T( "CREATERESOURCE_NO_TEXTURE_1D" ), D3D10_MESSAGE_ID_CREATERESOURCE_NO_TEXTURE_1D )
    NAMED_VALUE( _T( "CREATERESOURCE_DIMENSION_OUT_OF_RANGE" ), D3D10_MESSAGE_ID_CREATERESOURCE_DIMENSION_OUT_OF_RANGE )
    NAMED_VALUE( _T( "CREATERESOURCE_NOT_BINDABLE_AS_SHADER_RESOURCE" ), D3D10_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_SHADER_RESOURCE )
    NAMED_VALUE( _T( "OMSETRENDERTARGETS_TOO_MANY_RENDER_TARGETS" ), D3D10_MESSAGE_ID_OMSETRENDERTARGETS_TOO_MANY_RENDER_TARGETS )
    NAMED_VALUE( _T( "OMSETRENDERTARGETS_NO_DIFFERING_BIT_DEPTHS" ), D3D10_MESSAGE_ID_OMSETRENDERTARGETS_NO_DIFFERING_BIT_DEPTHS )
    NAMED_VALUE( _T( "IASETVERTEXBUFFERS_BAD_BUFFER_INDEX" ), D3D10_MESSAGE_ID_IASETVERTEXBUFFERS_BAD_BUFFER_INDEX )
    NAMED_VALUE( _T( "DEVICE_RSSETVIEWPORTS_TOO_MANY_VIEWPORTS" ), D3D10_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_TOO_MANY_VIEWPORTS )
    NAMED_VALUE( _T( "DEVICE_IASETPRIMITIVETOPOLOGY_ADJACENCY_UNSUPPORTED" ), D3D10_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_ADJACENCY_UNSUPPORTED )
    NAMED_VALUE( _T( "DEVICE_RSSETSCISSORRECTS_TOO_MANY_SCISSORS" ), D3D10_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_TOO_MANY_SCISSORS )
    NAMED_VALUE( _T( "COPYRESOURCE_ONLY_TEXTURE_2D_WITHIN_GPU_MEMORY" ), D3D10_MESSAGE_ID_COPYRESOURCE_ONLY_TEXTURE_2D_WITHIN_GPU_MEMORY )
    NAMED_VALUE( _T( "COPYRESOURCE_NO_TEXTURE_3D_READBACK" ), D3D10_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_3D_READBACK )
    NAMED_VALUE( _T( "COPYRESOURCE_NO_TEXTURE_ONLY_READBACK" ), D3D10_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_ONLY_READBACK )
    NAMED_VALUE( _T( "CREATEINPUTLAYOUT_UNSUPPORTED_FORMAT" ), D3D10_MESSAGE_ID_CREATEINPUTLAYOUT_UNSUPPORTED_FORMAT )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_NO_ALPHA_TO_COVERAGE" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_NO_ALPHA_TO_COVERAGE )
    NAMED_VALUE( _T( "CREATERASTERIZERSTATE_DepthClipEnable_MUST_BE_TRUE" ), D3D10_MESSAGE_ID_CREATERASTERIZERSTATE_DepthClipEnable_MUST_BE_TRUE )
    NAMED_VALUE( _T( "DRAWINDEXED_STARTINDEXLOCATION_MUST_BE_POSITIVE" ), D3D10_MESSAGE_ID_DRAWINDEXED_STARTINDEXLOCATION_MUST_BE_POSITIVE )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_MUST_USE_LOWEST_LOD" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_MUST_USE_LOWEST_LOD )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_MINLOD_MUST_NOT_BE_FRACTIONAL" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_MINLOD_MUST_NOT_BE_FRACTIONAL )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_MAXLOD_MUST_BE_FLT_MAX" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_MAXLOD_MUST_BE_FLT_MAX )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_FIRSTARRAYSLICE_MUST_BE_ZERO" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_FIRSTARRAYSLICE_MUST_BE_ZERO )
    NAMED_VALUE( _T( "CREATESHADERRESOURCEVIEW_CUBES_MUST_HAVE_6_SIDES" ), D3D10_MESSAGE_ID_CREATESHADERRESOURCEVIEW_CUBES_MUST_HAVE_6_SIDES )
    NAMED_VALUE( _T( "CREATERESOURCE_NOT_BINDABLE_AS_RENDER_TARGET" ), D3D10_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_RENDER_TARGET )
    NAMED_VALUE( _T( "CREATERESOURCE_NO_DWORD_INDEX_BUFFER" ), D3D10_MESSAGE_ID_CREATERESOURCE_NO_DWORD_INDEX_BUFFER )
    NAMED_VALUE( _T( "CREATERESOURCE_MSAA_PRECLUDES_SHADER_RESOURCE" ), D3D10_MESSAGE_ID_CREATERESOURCE_MSAA_PRECLUDES_SHADER_RESOURCE )
    NAMED_VALUE( _T( "CREATERESOURCE_PRESENTATION_PRECLUDES_SHADER_RESOURCE" ), D3D10_MESSAGE_ID_CREATERESOURCE_PRESENTATION_PRECLUDES_SHADER_RESOURCE )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_NO_INDEPENDENT_BLEND_ENABLE" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_BLEND_ENABLE )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_NO_INDEPENDENT_WRITE_MASKS" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_WRITE_MASKS )
    NAMED_VALUE( _T( "CREATERESOURCE_NO_STREAM_OUT" ), D3D10_MESSAGE_ID_CREATERESOURCE_NO_STREAM_OUT )
    NAMED_VALUE( _T( "CREATERESOURCE_ONLY_VB_IB_FOR_BUFFERS" ), D3D10_MESSAGE_ID_CREATERESOURCE_ONLY_VB_IB_FOR_BUFFERS )
    NAMED_VALUE( _T( "CREATERESOURCE_NO_AUTOGEN_FOR_VOLUMES" ), D3D10_MESSAGE_ID_CREATERESOURCE_NO_AUTOGEN_FOR_VOLUMES )
    NAMED_VALUE( _T( "CREATERESOURCE_DXGI_FORMAT_R8G8B8A8_CANNOT_BE_SHARED" ), D3D10_MESSAGE_ID_CREATERESOURCE_DXGI_FORMAT_R8G8B8A8_CANNOT_BE_SHARED )
    NAMED_VALUE( _T( "VSSHADERRESOURCES_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_VSSHADERRESOURCES_NOT_SUPPORTED )
    NAMED_VALUE( _T( "GEOMETRY_SHADER_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_GEOMETRY_SHADER_NOT_SUPPORTED )
    NAMED_VALUE( _T( "STREAM_OUT_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_STREAM_OUT_NOT_SUPPORTED )
    NAMED_VALUE( _T( "TEXT_FILTER_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_TEXT_FILTER_NOT_SUPPORTED )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_NO_SEPARATE_ALPHA_BLEND" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_NO_SEPARATE_ALPHA_BLEND )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_NO_MRT_BLEND" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_NO_MRT_BLEND )
    NAMED_VALUE( _T( "CREATEBLENDSTATE_OPERATION_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_CREATEBLENDSTATE_OPERATION_NOT_SUPPORTED )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_NO_MIRRORONCE" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_NO_MIRRORONCE )
    NAMED_VALUE( _T( "DRAWINSTANCED_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_DRAWINSTANCED_NOT_SUPPORTED )
    NAMED_VALUE( _T( "DRAWINDEXEDINSTANCED_NOT_SUPPORTED_BELOW_9_3" ), D3D10_MESSAGE_ID_DRAWINDEXEDINSTANCED_NOT_SUPPORTED_BELOW_9_3 )
    NAMED_VALUE( _T( "DRAWINDEXED_POINTLIST_UNSUPPORTED" ), D3D10_MESSAGE_ID_DRAWINDEXED_POINTLIST_UNSUPPORTED )
    NAMED_VALUE( _T( "SETBLENDSTATE_SAMPLE_MASK_CANNOT_BE_ZERO" ), D3D10_MESSAGE_ID_SETBLENDSTATE_SAMPLE_MASK_CANNOT_BE_ZERO )
    NAMED_VALUE( _T( "CREATERESOURCE_DIMENSION_EXCEEDS_FEATURE_LEVEL_DEFINITION" ), D3D10_MESSAGE_ID_CREATERESOURCE_DIMENSION_EXCEEDS_FEATURE_LEVEL_DEFINITION )
    NAMED_VALUE( _T( "CREATERESOURCE_ONLY_SINGLE_MIP_LEVEL_DEPTH_STENCIL_SUPPORTED" ), D3D10_MESSAGE_ID_CREATERESOURCE_ONLY_SINGLE_MIP_LEVEL_DEPTH_STENCIL_SUPPORTED )
    NAMED_VALUE( _T( "DEVICE_RSSETSCISSORRECTS_NEGATIVESCISSOR" ), D3D10_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_NEGATIVESCISSOR )
    NAMED_VALUE( _T( "SLOT_ZERO_MUST_BE_D3D10_INPUT_PER_VERTEX_DATA" ), D3D10_MESSAGE_ID_SLOT_ZERO_MUST_BE_D3D10_INPUT_PER_VERTEX_DATA )
    NAMED_VALUE( _T( "CREATERESOURCE_NON_POW_2_MIPMAP" ), D3D10_MESSAGE_ID_CREATERESOURCE_NON_POW_2_MIPMAP )
    NAMED_VALUE( _T( "CREATESAMPLERSTATE_BORDER_NOT_SUPPORTED" ), D3D10_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_NOT_SUPPORTED )
    NAMED_VALUE( _T( "OMSETRENDERTARGETS_NO_SRGB_MRT" ), D3D10_MESSAGE_ID_OMSETRENDERTARGETS_NO_SRGB_MRT )
    NAMED_VALUE( _T( "D3D10L9_MESSAGES_END" ), D3D10_MESSAGE_ID_D3D10L9_MESSAGES_END )
END_NAMED_VALUES( D3D10_MESSAGE_ID )

BEGIN_NAMED_VALUES( D3D10_DRIVER_TYPE )
    NAMED_VALUE( _T( "HW" ), D3D10_DRIVER_TYPE_HARDWARE )
    NAMED_VALUE( _T( "REF" ), D3D10_DRIVER_TYPE_REFERENCE )
    NAMED_VALUE( _T( "NULL" ), D3D10_DRIVER_TYPE_NULL )
    NAMED_VALUE( _T( "SW" ), D3D10_DRIVER_TYPE_SOFTWARE )
    NAMED_VALUE( _T( "WARP" ), D3D10_DRIVER_TYPE_WARP )
END_NAMED_VALUES( D3D10_DRIVER_TYPE )

BEGIN_NAMED_VALUES( D3D10_FEATURE_LEVEL1 )
    NAMED_VALUE( _T( "10_0" ), D3D10_FEATURE_LEVEL_10_0 )
    NAMED_VALUE( _T( "10_1" ), D3D10_FEATURE_LEVEL_10_1 )
    NAMED_VALUE( _T( "9_1" ), D3D10_FEATURE_LEVEL_9_1 )
    NAMED_VALUE( _T( "9_2" ), D3D10_FEATURE_LEVEL_9_2 )
    NAMED_VALUE( _T( "9_3" ), D3D10_FEATURE_LEVEL_9_3 )
END_NAMED_VALUES( D3D10_FEATURE_LEVEL1 )

BEGIN_NAMED_VALUES( D3D10_STANDARD_MULTISAMPLE_QUALITY_LEVELS )
    NAMED_VALUE( _T( "STANDARD_MULTISAMPLE_PATTERN" ), D3D10_STANDARD_MULTISAMPLE_PATTERN )
    NAMED_VALUE( _T( "CENTER_MULTISAMPLE_PATTERN" ), D3D10_CENTER_MULTISAMPLE_PATTERN )
END_NAMED_VALUES( D3D10_STANDARD_MULTISAMPLE_QUALITY_LEVELS )

